/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageRange;

public class MessageBatcher {
    public static final int NO_BATCH_SIZE = 0;
    private final int moveBatchSize;

    public MessageBatcher(int moveBatchSize) {
        Preconditions.checkArgument((moveBatchSize >= 0 ? 1 : 0) != 0);
        this.moveBatchSize = moveBatchSize;
    }

    public List<MessageRange> batchMessages(MessageRange set, BatchedOperation batchedOperation) throws MailboxException {
        if (this.moveBatchSize > 0) {
            ArrayList<MessageRange> movedRanges = new ArrayList<MessageRange>();
            for (MessageRange messageRange : set.split(this.moveBatchSize)) {
                movedRanges.addAll(batchedOperation.execute(messageRange));
            }
            return movedRanges;
        }
        return batchedOperation.execute(set);
    }

    public static interface BatchedOperation {
        public List<MessageRange> execute(MessageRange var1) throws MailboxException;
    }
}

