/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CompletableFutureUtil {
    public static <T> CompletableFuture<Optional<T>> unwrap(CompletableFuture<Optional<CompletableFuture<T>>> base) {
        return base.thenCompose(optional -> optional.map(future -> future.thenApply(Optional::of)).orElse(CompletableFuture.completedFuture(Optional.empty())));
    }

    public static <T, U, V> CompletableFuture<V> combine(CompletableFuture<T> t, CompletableFuture<U> u, BiFunction<T, U, V> combiner) {
        return t.thenCompose(valueT -> u.thenApply(valueU -> combiner.apply(valueT, valueU)));
    }

    public static <T> CompletableFuture<Stream<T>> allOf(Stream<CompletableFuture<T>> futureStream) {
        return ((Stream)futureStream.map(future -> future.thenApply(Stream::of)).parallel()).reduce((future1, future2) -> future1.thenCompose(stream1 -> future2.thenCompose(stream2 -> {
            Stream concatStream = Stream.concat(stream1, stream2);
            return CompletableFuture.completedFuture(concatStream);
        }))).orElse(CompletableFuture.completedFuture(Stream.of(new Object[0])));
    }

    public static <R, T> CompletableFuture<Stream<R>> chainAll(Stream<T> futureStream, Function<T, CompletableFuture<R>> transformationToChain) {
        return futureStream.map(t -> () -> (CompletableFuture)transformationToChain.apply(t)).reduce(CompletableFuture.completedFuture(Stream.of(new Object[0])), (accumulator, supplier) -> accumulator.thenCompose(arg_0 -> CompletableFutureUtil.lambda$null$11((Supplier)supplier, arg_0)), CompletableFutureUtil.getCompletableFutureBinaryOperator());
    }

    private static <R> BinaryOperator<CompletableFuture<Stream<R>>> getCompletableFutureBinaryOperator() {
        return (future1, future2) -> future1.thenCompose(stream1 -> future2.thenCompose(stream2 -> CompletableFuture.completedFuture(Stream.concat(stream1, stream2))));
    }

    public static <T, U> CompletableFuture<Stream<U>> map(CompletableFuture<Stream<T>> futurStream, Function<T, U> action) {
        return futurStream.thenApply(stream -> stream.map(action));
    }

    public static <T> CompletableFuture<Optional<T>> reduce(BinaryOperator<T> binaryOperator, CompletableFuture<Stream<T>> futureStream) {
        return futureStream.thenApply(stream -> stream.reduce(binaryOperator));
    }

    public static <T> CompletableFuture<T> reduce(BinaryOperator<T> binaryOperator, CompletableFuture<Stream<T>> futureStream, T emptyAccumulator) {
        return futureStream.thenApply(stream -> stream.reduce(binaryOperator).orElse(emptyAccumulator));
    }

    public static <T> Function<Boolean, CompletableFuture<Boolean>> composeIfTrue(Supplier<CompletableFuture<T>> composeOperation) {
        return b -> {
            if (b.booleanValue()) {
                return ((CompletableFuture)composeOperation.get()).thenApply(any -> b);
            }
            return CompletableFuture.completedFuture(b);
        };
    }

    public static <T> CompletableFuture<Stream<T>> sorted(CompletableFuture<Stream<T>> futureStream, Comparator<T> comparator) {
        return futureStream.thenApply(stream -> stream.sorted(comparator));
    }

    public static <T> CompletableFuture<T> exceptionallyFuture(Throwable throwable) {
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(throwable);
        return failedFuture;
    }

    private static /* synthetic */ CompletionStage lambda$null$11(Supplier supplier, Stream accumulatedStream) {
        return ((CompletableFuture)supplier.get()).thenCompose(r -> CompletableFuture.completedFuture(Stream.concat(accumulatedStream, Stream.of(r))));
    }
}

