/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.MappingArgument;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class MailAttributesToMimeHeaders
extends GenericMailet {
    private Map<String, String> mappings;

    public void init() throws MessagingException {
        String simpleMappings = this.getInitParameter("simplemapping");
        if (Strings.isNullOrEmpty((String)simpleMappings)) {
            throw new MessagingException("simplemapping is required");
        }
        this.mappings = MappingArgument.parse(simpleMappings);
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            String value = (String)((Object)mail.getAttribute(entry.getKey()));
            if (value == null) continue;
            String headerName = entry.getValue();
            message.addHeader(headerName, value);
        }
        message.saveChanges();
    }
}

