/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.MappingArgument;
import org.apache.james.util.OptionalUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAttributesListToMimeHeaders
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAttributesListToMimeHeaders.class);
    private Map<String, String> attributeNameToHeader;

    public void init() throws MessagingException {
        String simpleMappings = this.getInitParameter("simplemapping");
        if (Strings.isNullOrEmpty((String)simpleMappings)) {
            throw new MessagingException("simplemapping is required");
        }
        this.attributeNameToHeader = MappingArgument.parse(simpleMappings);
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        this.attributeNameToHeader.entrySet().forEach(entry -> this.addAttributeToHeader(mail, message, (Map.Entry<String, String>)entry));
        message.saveChanges();
    }

    private void addAttributeToHeader(Mail mail, MimeMessage message, Map.Entry<String, String> entry) {
        Serializable attribute = mail.getAttribute(entry.getKey());
        if (attribute instanceof Collection) {
            Optional<Collection<Serializable>> values = Optional.of((Collection)((Object)attribute));
            this.addCollectionToHeader(message, entry.getValue(), values);
        } else if (attribute != null) {
            LOGGER.warn("Can not add {} to headers. Expecting class Collection but got {}.", (Object)attribute, attribute.getClass());
        }
    }

    private void addCollectionToHeader(MimeMessage message, String headerName, Optional<Collection<Serializable>> values) {
        OptionalUtils.toStream(values).flatMap(Collection::stream).forEach(value -> this.addValueToHeader(message, headerName, value));
    }

    private void addValueToHeader(MimeMessage message, String headerName, Object value) {
        try {
            if (value instanceof String) {
                message.addHeader(headerName, (String)value);
            } else if (value != null) {
                LOGGER.warn("Invalid type for value intended to be added as {} header. Expecting String but got {}", (Object)headerName, value.getClass());
            }
        }
        catch (MessagingException e) {
            LOGGER.warn("Could not add header {} with value {}", (Object)headerName, value);
        }
    }
}

