/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class HeadersToHTTP
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadersToHTTP.class);
    private String url;
    private String parameterKey = null;
    private String parameterValue = null;
    private boolean passThrough = true;

    public void init() throws MessagingException {
        this.passThrough = this.getInitParameter("passThrough", "true").compareToIgnoreCase("true") == 0;
        String targetUrl = this.getInitParameter("url");
        this.parameterKey = this.getInitParameter("parameterKey");
        this.parameterValue = this.getInitParameter("parameterValue");
        if (targetUrl == null || targetUrl.equals("")) {
            throw new MessagingException("Please configure a targetUrl (\"url\")");
        }
        try {
            this.url = new URL(targetUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new MessagingException("Unable to contruct URL object from url");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("I will attempt to deliver serialised messages to " + targetUrl + ". " + (this.parameterKey == null || this.parameterKey.length() < 1 ? "I will not add any fields to the post. " : "I will prepend: " + this.parameterKey + "=" + this.parameterValue + ". ") + (this.passThrough ? "Messages will pass through." : "Messages will be ghosted."));
        }
    }

    public void service(Mail mail) {
        try {
            LOGGER.debug("{} HeadersToHTTP: Starting", (Object)mail.getName());
            MimeMessage message = mail.getMessage();
            HashSet<NameValuePair> pairs = this.getNameValuePairs(message);
            LOGGER.debug("{} HeadersToHTTP: {} named value pairs found", (Object)mail.getName(), (Object)pairs.size());
            String result = this.httpPost(pairs);
            if (this.passThrough) {
                this.addHeader(mail, true, result);
            } else {
                mail.setState("ghost");
            }
        }
        catch (IOException | MessagingException e) {
            LOGGER.error("Exception", e);
            this.addHeader(mail, false, e.getMessage());
        }
    }

    private void addHeader(Mail mail, boolean success, String errorMessage) {
        try {
            MimeMessage message = mail.getMessage();
            message.setHeader("X-headerToHTTP", success ? "Succeeded" : "Failed");
            if (!success && errorMessage != null && errorMessage.length() > 0) {
                message.setHeader("X-headerToHTTPFailure", errorMessage);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            LOGGER.error("Exception", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String httpPost(HashSet<NameValuePair> pairs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashSet<NameValuePair> getNameValuePairs(MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        HashSet<NameValuePair> pairs = new HashSet<NameValuePair>();
        if (message != null) {
            if (message.getSender() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("from", message.getSender().toString()));
            }
            if (message.getReplyTo() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("reply_to", Arrays.toString(message.getReplyTo())));
            }
            if (message.getMessageID() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("message_id", message.getMessageID()));
            }
            if (message.getSubject() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("subject", message.getSubject()));
            }
            pairs.add((NameValuePair)new BasicNameValuePair("size", Integer.toString(message.getSize())));
        }
        pairs.add((NameValuePair)new BasicNameValuePair(this.parameterKey, this.parameterValue));
        return pairs;
    }

    public String getMailetInfo() {
        return "HTTP POST serialised message";
    }
}

