/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.protocols.imap.IMAPSession;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelLocal;

public class IMAPMDCContext {
    public static Closeable from(ChannelHandlerContext ctx, ChannelLocal<Object> attributes) {
        return MDCBuilder.create().addContext(IMAPMDCContext.from(attributes.get(ctx.getChannel()))).addContext("protocol", (Object)"IMAP").addContext("ip", (Object)IMAPMDCContext.retrieveIp(ctx)).addContext("host", (Object)IMAPMDCContext.retrieveHost(ctx)).build();
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    private static MDCBuilder from(Object o) {
        return Optional.ofNullable(o).filter(object -> object instanceof IMAPSession).map(object -> (IMAPSession)object).map(imapSession -> MDCBuilder.create().addContext("sessionId", (Object)imapSession.getSessionID()).addContext("user", (Object)imapSession.getUser()).addContext(IMAPMDCContext.from(Optional.ofNullable(imapSession.getSelected())))).orElse(MDCBuilder.create());
    }

    private static MDCBuilder from(Optional<SelectedMailbox> selectedMailbox) {
        return selectedMailbox.map(value -> MDCBuilder.create().addContext("selectedMailbox", (Object)value.getPath().asString())).orElse(MDCBuilder.create());
    }
}

