/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.system.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.james.domainlist.hbase.def.HDomainList;
import org.apache.james.rrt.hbase.def.HRecipientRewriteTable;
import org.apache.james.user.hbase.def.HUsersRepository;

@Deprecated
public class TablePool {
    private static Configuration configuration;
    private static TablePool hbaseSchema;
    private static HTablePool htablePool;

    public static synchronized TablePool getInstance() throws IOException {
        return TablePool.getInstance(HBaseConfiguration.create());
    }

    public static synchronized TablePool getInstance(Configuration configuration) throws IOException {
        if (hbaseSchema == null) {
            TablePool.configuration = configuration;
            hbaseSchema = new TablePool();
            htablePool = new HTablePool(configuration, 100);
            TablePool.ensureTable(HDomainList.TABLE_NAME, HDomainList.COLUMN_FAMILY_NAME);
            TablePool.ensureTable(HRecipientRewriteTable.TABLE_NAME, HRecipientRewriteTable.COLUMN_FAMILY_NAME);
            TablePool.ensureTable(HUsersRepository.TABLE_NAME, HUsersRepository.COLUMN_FAMILY_NAME);
        }
        return hbaseSchema;
    }

    public HTableInterface getDomainlistTable() {
        return htablePool.getTable(HDomainList.TABLE_NAME);
    }

    public HTableInterface getRecipientRewriteTable() {
        return htablePool.getTable(HRecipientRewriteTable.TABLE_NAME);
    }

    public HTableInterface getUsersRepositoryTable() {
        return htablePool.getTable(HUsersRepository.TABLE_NAME);
    }

    private static void ensureTable(byte[] tableName, byte[] columnFamilyName) throws IOException {
        try (HBaseAdmin hbaseAdmin = new HBaseAdmin(configuration);){
            if (!hbaseAdmin.tableExists(tableName)) {
                HTableDescriptor desc = new HTableDescriptor(tableName);
                HColumnDescriptor hColumnDescriptor = new HColumnDescriptor(columnFamilyName);
                hColumnDescriptor.setMaxVersions(1);
                desc.addFamily(hColumnDescriptor);
                hbaseAdmin.createTable(desc);
            }
        }
    }
}

