/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.hbase.def.HDomainList;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.system.hbase.TablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HBaseDomainList
extends AbstractDomainList {
    private static final Logger log = LoggerFactory.getLogger((String)HBaseDomainList.class.getName());

    @Inject
    public HBaseDomainList(DNSService dns) {
        super(dns);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean containsDomainInternal(Domain domain) throws DomainListException {
        try (HTableInterface table = TablePool.getInstance().getDomainlistTable();){
            Get get = new Get(Bytes.toBytes((String)domain.asString()));
            Result result = table.get(get);
            if (result.isEmpty()) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("Error while counting domains from HBase", (Throwable)e);
            throw new DomainListException("Error while counting domains from HBase", (Throwable)e);
        }
    }

    public void addDomain(Domain domain) throws DomainListException {
        if (this.containsDomain(domain)) {
            throw new DomainListException(domain.name() + " already exists.");
        }
        try (HTableInterface table = TablePool.getInstance().getDomainlistTable();){
            Put put = new Put(Bytes.toBytes((String)domain.asString()));
            put.add(HDomainList.COLUMN_FAMILY_NAME, HDomainList.COLUMN.DOMAIN, null);
            table.put(put);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while adding domain in HBase", (Throwable)e);
            throw new DomainListException("Error while adding domain in HBase", (Throwable)e);
        }
    }

    public void removeDomain(Domain domain) throws DomainListException {
        try (HTableInterface table = TablePool.getInstance().getDomainlistTable();){
            Delete delete = new Delete(Bytes.toBytes((String)domain.asString()));
            table.delete(delete);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while deleting user from HBase", (Throwable)e);
            throw new DomainListException("Error while deleting domain from HBase", (Throwable)e);
        }
    }

    protected List<Domain> getDomainListInternal() throws DomainListException {
        ArrayList<Domain> list = new ArrayList<Domain>();
        try (HTableInterface table = TablePool.getInstance().getDomainlistTable();){
            Scan scan = new Scan();
            scan.addFamily(HDomainList.COLUMN_FAMILY_NAME);
            scan.setCaching(table.getConfiguration().getInt("hbase.client.scanner.caching", 1) * 2);
            try (ResultScanner resultScanner = table.getScanner(scan);){
                Result result;
                while ((result = resultScanner.next()) != null) {
                    list.add(Domain.of((String)Bytes.toString((byte[])result.getRow())));
                }
            }
        }
        catch (IOException e) {
            log.error("Error while counting domains from HBase", (Throwable)e);
            throw new DomainListException("Error while counting domains from HBase", (Throwable)e);
        }
        return list;
    }
}

