/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.fge.lambdas.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.core.quota.QuotaValue;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.SerializableQuota;
import org.apache.james.mailbox.model.SerializableQuotaValue;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.util.MDCBuilder;

public class QuotaManagement
implements QuotaManagementMBean {
    private final QuotaManager quotaManager;
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public QuotaManagement(QuotaManager quotaManager, MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver) {
        this.quotaManager = quotaManager;
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getQuotaRoot").build();){
            String string = this.quotaRootResolver.getQuotaRoot(new MailboxPath(namespace, user, name)).getValue();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableQuotaValue<QuotaCount> getMaxMessageCount(String quotaRoot) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getMaxMessageCount").build();){
            SerializableQuotaValue serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getMaxMessage(this.quotaRootResolver.fromString(quotaRoot)));
            return serializableQuotaValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableQuotaValue<QuotaSize> getMaxStorage(String quotaRoot) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getMaxStorage").build();){
            SerializableQuotaValue serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getMaxStorage(this.quotaRootResolver.fromString(quotaRoot)));
            return serializableQuotaValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableQuotaValue<QuotaCount> getGlobalMaxMessageCount() throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getGlobalMaxMessageCount").build();){
            SerializableQuotaValue serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getGlobalMaxMessage());
            return serializableQuotaValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableQuotaValue<QuotaSize> getGlobalMaxStorage() throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getGlobalMaxStorage").build();){
            SerializableQuotaValue serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getGlobalMaxStorage());
            return serializableQuotaValue;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMaxMessageCount(String quotaRoot, SerializableQuotaValue<QuotaCount> maxMessageCount) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setMaxMessageCount").build();){
            maxMessageCount.toValue(QuotaCount::count, (QuotaValue)QuotaCount.unlimited()).ifPresent(Throwing.consumer(value -> this.maxQuotaManager.setMaxMessage(this.quotaRootResolver.fromString(quotaRoot), value)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMaxStorage(String quotaRoot, SerializableQuotaValue<QuotaSize> maxSize) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setMaxStorage").build();){
            maxSize.toValue(QuotaSize::size, (QuotaValue)QuotaSize.unlimited()).ifPresent(Throwing.consumer(value -> this.maxQuotaManager.setMaxStorage(this.quotaRootResolver.fromString(quotaRoot), value)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setGlobalMaxMessageCount(SerializableQuotaValue<QuotaCount> maxGlobalMessageCount) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setGlobalMaxMessageCount").build();){
            maxGlobalMessageCount.toValue(QuotaCount::count, (QuotaValue)QuotaCount.unlimited()).ifPresent(Throwing.consumer(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).setGlobalMaxMessage(arg_0)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setGlobalMaxStorage(SerializableQuotaValue<QuotaSize> maxGlobalSize) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setGlobalMaxStorage").build();){
            maxGlobalSize.toValue(QuotaSize::size, (QuotaValue)QuotaSize.unlimited()).ifPresent(Throwing.consumer(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).setGlobalMaxStorage(arg_0)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableQuota<QuotaCount> getMessageCountQuota(String quotaRoot) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getMessageCountQuota").build();){
            SerializableQuota serializableQuota = SerializableQuota.newInstance((Quota)this.quotaManager.getMessageQuota(this.quotaRootResolver.fromString(quotaRoot)));
            return serializableQuota;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableQuota<QuotaSize> getStorageQuota(String quotaRoot) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getStorageQuota").build();){
            SerializableQuota serializableQuota = SerializableQuota.newInstance((Quota)this.quotaManager.getStorageQuota(this.quotaRootResolver.fromString(quotaRoot)));
            return serializableQuota;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

