/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.util;

import org.apache.james.managesieve.api.ArgumentException;

public class ParserUtils {
    public static long getSize(String args) throws ArgumentException {
        if (args != null && args.length() > 3 && args.charAt(0) == '{' && args.charAt(args.length() - 1) == '}' && args.charAt(args.length() - 2) == '+') {
            try {
                return Long.parseLong(args.substring(1, args.length() - 2));
            }
            catch (NumberFormatException e) {
                throw new ArgumentException("Size is not a long : " + e.getMessage(), e);
            }
        }
        throw new ArgumentException(args + " is an invalid size literal : it should be at least 4 char looking like {_+}");
    }

    public static String unquote(String quoted) {
        String result = quoted;
        if (quoted != null) {
            if (quoted.startsWith("\"") && quoted.endsWith("\"")) {
                result = quoted.substring(1, quoted.length() - 1);
            } else if (quoted.startsWith("'") && quoted.endsWith("'")) {
                result = quoted.substring(1, quoted.length() - 1);
            }
        }
        return result;
    }
}

