/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer.registrations;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.model.MailboxPath;

public class GlobalRegistration
implements MailboxListener {
    private final ConcurrentHashMap<MailboxPath, Boolean> isPathDeleted = new ConcurrentHashMap();
    private final ConcurrentHashMap<MailboxPath, MailboxPath> nameCorrespondence = new ConcurrentHashMap();

    public Optional<MailboxPath> getPathToIndex(MailboxPath mailboxPath) {
        if (this.isPathDeleted.get(mailboxPath) != null) {
            return Optional.empty();
        }
        return Optional.of(Optional.ofNullable(this.nameCorrespondence.get(mailboxPath)).orElse(mailboxPath));
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.EACH_NODE;
    }

    public void event(Event event) {
        if (event instanceof MailboxListener.MailboxDeletion) {
            MailboxListener.MailboxDeletion mailboxDeletion = (MailboxListener.MailboxDeletion)event;
            this.isPathDeleted.put(mailboxDeletion.getMailboxPath(), true);
        } else if (event instanceof MailboxListener.MailboxRenamed) {
            MailboxListener.MailboxRenamed mailboxRenamed = (MailboxListener.MailboxRenamed)event;
            this.nameCorrespondence.put(mailboxRenamed.getMailboxPath(), ((MailboxListener.MailboxRenamed)event).getNewPath());
        }
    }
}

