/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;

public class SingleMessageReindexingTask
implements Task {
    public static final String MESSAGE_RE_INDEXING = "messageReIndexing";
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxPath path;
    private final MessageUid uid;
    private final AdditionalInformation additionalInformation;

    @Inject
    public SingleMessageReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxPath path, MessageUid uid) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.path = path;
        this.uid = uid;
        this.additionalInformation = new AdditionalInformation(path, uid);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.handleMessageReIndexing(this.path, this.uid);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return MESSAGE_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailboxPath mailboxPath;
        private final MessageUid uid;

        AdditionalInformation(MailboxPath mailboxPath, MessageUid uid) {
            this.mailboxPath = mailboxPath;
            this.uid = uid;
        }

        public String getMailboxPath() {
            return this.mailboxPath.asString();
        }

        public long getUid() {
            return this.uid.asLong();
        }
    }
}

