/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;

public class SingleMailboxReindexingTask
implements Task {
    public static final String MAILBOX_RE_INDEXING = "mailboxReIndexing";
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxPath path;
    private final AdditionalInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public SingleMailboxReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxPath path) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.path = path;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new AdditionalInformation(path, this.reprocessingContext);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.path, this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return MAILBOX_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailboxPath mailboxPath;
        private final ReprocessingContext reprocessingContext;

        AdditionalInformation(MailboxPath mailboxPath, ReprocessingContext reprocessingContext) {
            this.mailboxPath = mailboxPath;
            this.reprocessingContext = reprocessingContext;
        }

        public String getMailboxPath() {
            return this.mailboxPath.asString();
        }

        public int getSuccessfullyReprocessMailCount() {
            return this.reprocessingContext.successfullyReprocessedMailCount();
        }

        public int getFailedReprocessedMailCount() {
            return this.reprocessingContext.failedReprocessingMailCount();
        }
    }
}

