/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.task.Task;

public class ReprocessingContext {
    private final AtomicInteger successfullyReprocessedMails;
    private final AtomicInteger failedReprocessingMails = new AtomicInteger(0);

    public ReprocessingContext() {
        this.successfullyReprocessedMails = new AtomicInteger(0);
    }

    public void updateAccordingToReprocessingResult(Task.Result result) {
        switch (result) {
            case COMPLETED: {
                this.successfullyReprocessedMails.incrementAndGet();
                break;
            }
            case PARTIAL: {
                this.failedReprocessingMails.incrementAndGet();
            }
        }
    }

    public int successfullyReprocessedMailCount() {
        return this.successfullyReprocessedMails.get();
    }

    public int failedReprocessingMailCount() {
        return this.failedReprocessingMails.get();
    }
}

