/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.task.Task;
import org.apache.james.util.OptionalUtils;
import org.apache.james.util.streams.Iterators;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.registrations.GlobalRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReIndexerPerformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReIndexerPerformer.class);
    private static final int NO_LIMIT = 0;
    private static final int SINGLE_MESSAGE = 1;
    private final MailboxManager mailboxManager;
    private final ListeningMessageSearchIndex messageSearchIndex;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;

    @Inject
    public ReIndexerPerformer(MailboxManager mailboxManager, ListeningMessageSearchIndex messageSearchIndex, MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        this.mailboxManager = mailboxManager;
        this.messageSearchIndex = messageSearchIndex;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
    }

    Task.Result reIndex(MailboxPath path, ReprocessingContext reprocessingContext) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(path.getUser());
        return this.reIndex(path, mailboxSession, reprocessingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task.Result reIndex(ReprocessingContext reprocessingContext) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession("re-indexing");
        LOGGER.info("Starting a full reindex");
        List mailboxPaths = this.mailboxManager.list(mailboxSession);
        try {
            Task.Result result = this.reIndex(mailboxPaths, mailboxSession, reprocessingContext);
            return result;
        }
        finally {
            LOGGER.info("Full reindex finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task.Result reIndex(User user, ReprocessingContext reprocessingContext) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(user.asString());
        LOGGER.info("Starting a reindex for user {}", (Object)user.asString());
        List mailboxPaths = (List)this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)mailboxSession).build(), mailboxSession).stream().map(MailboxMetaData::getPath).collect(ImmutableList.toImmutableList());
        try {
            Task.Result result = this.reIndex(mailboxPaths, mailboxSession, reprocessingContext);
            return result;
        }
        finally {
            LOGGER.info("User {} reindex finished", (Object)user.asString());
        }
    }

    Task.Result handleMessageReIndexing(MailboxPath path, MessageUid uid) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(path.getUser());
        Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxByPath(path);
        return this.handleMessageReIndexing(mailboxSession, mailbox, uid);
    }

    private Task.Result reIndex(List<MailboxPath> mailboxPaths, MailboxSession mailboxSession, ReprocessingContext reprocessingContext) throws MailboxException {
        return this.wrapInGlobalRegistration(mailboxSession, globalRegistration -> this.handleMultiMailboxesReindexingIterations(mailboxPaths, (GlobalRegistration)globalRegistration, reprocessingContext));
    }

    private Task.Result handleMultiMailboxesReindexingIterations(List<MailboxPath> mailboxPaths, GlobalRegistration globalRegistration, ReprocessingContext reprocessingContext) {
        return mailboxPaths.stream().map(globalRegistration::getPathToIndex).flatMap(OptionalUtils::toStream).map(path -> {
            try {
                return this.reIndex((MailboxPath)path, reprocessingContext);
            }
            catch (Throwable e) {
                LOGGER.error("Error while proceeding to full reindexing on {}", (Object)path.asString(), (Object)e);
                return Task.Result.PARTIAL;
            }
        }).reduce(Task::combine).orElse(Task.Result.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task.Result reIndex(MailboxPath path, MailboxSession mailboxSession, ReprocessingContext reprocessingContext) throws MailboxException {
        LOGGER.info("Intend to reindex {}", (Object)path.asString());
        Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxByPath(path);
        this.messageSearchIndex.deleteAll(mailboxSession, mailbox);
        try {
            Task.Result result = Iterators.toStream((Iterator)this.mailboxSessionMapperFactory.getMessageMapper(mailboxSession).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Metadata, 0)).map(MailboxMessage::getUid).map(uid -> this.handleMessageReIndexing(mailboxSession, mailbox, (MessageUid)uid)).peek(reprocessingContext::updateAccordingToReprocessingResult).reduce(Task::combine).orElse(Task.Result.COMPLETED);
            return result;
        }
        finally {
            LOGGER.info("Finish to reindex {}", (Object)path.asString());
        }
    }

    private Task.Result handleMessageReIndexing(MailboxSession mailboxSession, Mailbox mailbox, MessageUid uid) {
        try {
            Optional.of(uid).flatMap(Throwing.function(mUid -> this.fullyReadMessage(mailboxSession, mailbox, (MessageUid)mUid))).ifPresent(Throwing.consumer(message -> this.messageSearchIndex.add(mailboxSession, mailbox, message)));
            return Task.Result.COMPLETED;
        }
        catch (Exception e) {
            LOGGER.warn("ReIndexing failed for {} {}", new Object[]{mailbox.generateAssociatedPath(), uid, e});
            return Task.Result.PARTIAL;
        }
    }

    private Optional<MailboxMessage> fullyReadMessage(MailboxSession mailboxSession, Mailbox mailbox, MessageUid mUid) throws MailboxException {
        return Iterators.toStream((Iterator)this.mailboxSessionMapperFactory.getMessageMapper(mailboxSession).findInMailbox(mailbox, MessageRange.one((MessageUid)mUid), MessageMapper.FetchType.Full, 1)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T wrapInGlobalRegistration(MailboxSession session, Function<GlobalRegistration, T> function) throws MailboxException {
        GlobalRegistration globalRegistration = new GlobalRegistration();
        this.mailboxManager.addGlobalListener((MailboxListener)globalRegistration, session);
        try {
            T t = function.apply(globalRegistration);
            return t;
        }
        finally {
            this.mailboxManager.removeGlobalListener((MailboxListener)globalRegistration, session);
        }
    }
}

