/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import javax.inject.Inject;
import org.apache.james.core.User;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.task.Task;
import org.apache.mailbox.tools.indexer.FullReindexingTask;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTask;
import org.apache.mailbox.tools.indexer.SingleMessageReindexingTask;
import org.apache.mailbox.tools.indexer.UserReindexingTask;

public class ReIndexerImpl
implements ReIndexer {
    private final ReIndexerPerformer reIndexerPerformer;

    @Inject
    public ReIndexerImpl(ReIndexerPerformer reIndexerPerformer) {
        this.reIndexerPerformer = reIndexerPerformer;
    }

    public Task reIndex(MailboxPath path) {
        return new SingleMailboxReindexingTask(this.reIndexerPerformer, path);
    }

    public Task reIndex() {
        return new FullReindexingTask(this.reIndexerPerformer);
    }

    public Task reIndex(User user) {
        return new UserReindexingTask(this.reIndexerPerformer, user);
    }

    public Task reIndex(MailboxPath path, MessageUid uid) {
        return new SingleMessageReindexingTask(this.reIndexerPerformer, path, uid);
    }
}

