/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.user;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.apache.james.mailbox.store.user.model.impl.SimpleSubscription;

public class MaildirSubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private static final String FILE_SUBSCRIPTION = "subscriptions";
    private final MaildirStore store;

    public MaildirSubscriptionMapper(MaildirStore store) {
        this.store = store;
    }

    public void delete(Subscription subscription) throws SubscriptionException {
        boolean changed;
        Set<String> subscriptionNames = this.readSubscriptionsForUser(subscription.getUser());
        Sets.SetView newSubscriptions = Sets.difference(subscriptionNames, (Set)ImmutableSet.of((Object)subscription.getMailbox()));
        boolean bl = changed = subscriptionNames.size() != newSubscriptions.size();
        if (changed) {
            try {
                this.writeSubscriptions(new File(this.store.userRoot(subscription.getUser())), (Set<String>)newSubscriptions);
            }
            catch (IOException e) {
                throw new SubscriptionException((Exception)e);
            }
        }
    }

    public List<Subscription> findSubscriptionsForUser(String user) throws SubscriptionException {
        Set<String> subscriptionNames = this.readSubscriptionsForUser(user);
        return (List)subscriptionNames.stream().map(subscription -> new SimpleSubscription(user, subscription)).collect(Guavate.toImmutableList());
    }

    public Subscription findMailboxSubscriptionForUser(String user, String mailbox) throws SubscriptionException {
        Set<String> subscriptionNames;
        File userRoot = new File(this.store.userRoot(user));
        try {
            subscriptionNames = this.readSubscriptions(userRoot);
        }
        catch (IOException e) {
            throw new SubscriptionException((Exception)e);
        }
        if (subscriptionNames.contains(mailbox)) {
            return new SimpleSubscription(user, mailbox);
        }
        return null;
    }

    public void save(Subscription subscription) throws SubscriptionException {
        boolean changed;
        Set<String> subscriptionNames = this.readSubscriptionsForUser(subscription.getUser());
        ImmutableSet newSubscriptions = ImmutableSet.builder().addAll(subscriptionNames).add((Object)subscription.getMailbox()).build();
        boolean bl = changed = subscriptionNames.size() != newSubscriptions.size();
        if (changed) {
            try {
                this.writeSubscriptions(new File(this.store.userRoot(subscription.getUser())), (Set<String>)newSubscriptions);
            }
            catch (IOException e) {
                throw new SubscriptionException((Exception)e);
            }
        }
    }

    public void endRequest() {
    }

    private Set<String> readSubscriptionsForUser(String user) throws SubscriptionException {
        File userRoot = new File(this.store.userRoot(user));
        try {
            return this.readSubscriptions(userRoot);
        }
        catch (IOException e) {
            throw new SubscriptionException((Exception)e);
        }
    }

    /*
     * Exception decompiling
     */
    private Set<String> readSubscriptions(File mailboxFolder) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeSubscriptions(File mailboxFolder, Set<String> subscriptions) throws IOException {
        ArrayList<String> sortedSubscriptions = new ArrayList<String>(subscriptions);
        Collections.sort(sortedSubscriptions);
        if (!mailboxFolder.exists() && !mailboxFolder.mkdirs()) {
            throw new IOException("Could not create folder " + mailboxFolder);
        }
        File subscriptionFile = new File(mailboxFolder, FILE_SUBSCRIPTION);
        if (!subscriptionFile.exists() && !subscriptionFile.createNewFile()) {
            throw new IOException("Could not create file " + subscriptionFile);
        }
        try (FileWriter fileWriter = new FileWriter(subscriptionFile);
             PrintWriter writer = new PrintWriter(fileWriter);){
            sortedSubscriptions.forEach(writer::println);
        }
    }

    private static /* synthetic */ boolean lambda$readSubscriptions$1(String subscription) {
        return !subscription.equals("");
    }
}

