/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.mail.Flags;
import org.apache.commons.io.FileUtils;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.mail.model.MaildirMailboxMessage;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.mail.utils.ApplicableFlagCalculator;

public class MaildirMessageMapper
extends AbstractMessageMapper {
    private final MaildirStore maildirStore;
    private static final int BUF_SIZE = 2048;

    public MaildirMessageMapper(MailboxSession session, MaildirStore maildirStore) {
        super(session, (UidProvider)maildirStore, (ModSeqProvider)maildirStore);
        this.maildirStore = maildirStore;
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        File newFolder = folder.getNewFolder();
        File curFolder = folder.getCurFolder();
        File[] newFiles = newFolder.listFiles();
        File[] curFiles = curFolder.listFiles();
        if (newFiles == null || curFiles == null) {
            throw new MailboxException("Unable to count messages in Mailbox " + mailbox, (Throwable)new IOException("Not a valid Maildir folder: " + this.maildirStore.getFolderName(mailbox)));
        }
        return newFiles.length + curFiles.length;
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        File newFolder = folder.getNewFolder();
        File curFolder = folder.getCurFolder();
        String[] unseenMessages = curFolder.list(MaildirMessageName.FILTER_UNSEEN_MESSAGES);
        String[] newUnseenMessages = newFolder.list(MaildirMessageName.FILTER_UNSEEN_MESSAGES);
        if (newUnseenMessages == null || unseenMessages == null) {
            throw new MailboxException("Unable to count unseen messages in Mailbox " + mailbox, (Throwable)new IOException("Not a valid Maildir folder: " + this.maildirStore.getFolderName(mailbox)));
        }
        return newUnseenMessages.length + unseenMessages.length;
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            folder.delete(this.mailboxSession, message.getUid());
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to delete MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)e);
        }
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        List<MailboxMessage> results;
        MessageUid from = set.getUidFrom();
        MessageUid to = set.getUidTo();
        MessageRange.Type type = set.getType();
        switch (type) {
            default: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, MessageUid.MIN_VALUE, null, max);
                break;
            }
            case FROM: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, from, null, max);
                break;
            }
            case ONE: {
                results = this.findMessageInMailboxWithUID(mailbox, from);
                break;
            }
            case RANGE: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, null, from, to, max);
            }
        }
        return results.iterator();
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        SortedMap<MessageUid, MaildirMessageName> recentMessageNames = folder.getRecentMessages(this.mailboxSession);
        return new ArrayList<MessageUid>(recentMessageNames.keySet());
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        List<MailboxMessage> result = this.findMessagesInMailbox(mailbox, MaildirMessageName.FILTER_UNSEEN_MESSAGES, 1);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0).getUid();
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        ArrayList<UpdatedFlags> updatedFlags = new ArrayList<UpdatedFlags>();
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        Iterator<MailboxMessage> it = this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, -1);
        while (it.hasNext()) {
            MailboxMessage member = it.next();
            Flags originalFlags = member.createFlags();
            member.setFlags(flagsUpdateCalculator.buildNewFlags(originalFlags));
            Flags newFlags = member.createFlags();
            try {
                long modSeq;
                MaildirMessageName messageName = folder.getMessageNameByUid(this.mailboxSession, member.getUid());
                if (messageName == null) continue;
                File messageFile = messageName.getFile();
                messageName.setFlags(member.createFlags());
                String newMessageName = messageName.getFullName();
                File newMessageFile = newFlags.contains(Flags.Flag.RECENT) ? new File(folder.getNewFolder(), newMessageName) : new File(folder.getCurFolder(), newMessageName);
                if (!newMessageFile.equals(messageFile)) {
                    FileUtils.moveFile((File)messageFile, (File)newMessageFile);
                    modSeq = newMessageFile.lastModified();
                } else {
                    modSeq = messageFile.lastModified();
                }
                member.setModSeq(modSeq);
                updatedFlags.add(UpdatedFlags.builder().uid(member.getUid()).modSeq(member.getModSeq()).newFlags(newFlags).oldFlags(originalFlags).build());
                MessageUid uid = member.getUid();
                folder.update(this.mailboxSession, uid, newMessageName);
            }
            catch (IOException e) {
                throw new MailboxException("Failure while save MailboxMessage " + member + " in Mailbox " + mailbox, (Throwable)e);
            }
        }
        return updatedFlags.iterator();
    }

    public Map<MessageUid, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox mailbox, MessageRange set) throws MailboxException {
        List<Object> results = new ArrayList();
        MessageUid from = set.getUidFrom();
        MessageUid to = set.getUidTo();
        MessageRange.Type type = set.getType();
        switch (type) {
            default: {
                results = this.findMessagesInMailbox(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, -1);
                break;
            }
            case FROM: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, from, null, -1);
                break;
            }
            case ONE: {
                results = this.findDeletedMessageInMailboxWithUID(mailbox, from);
                break;
            }
            case RANGE: {
                results = this.findMessagesInMailboxBetweenUIDs(mailbox, MaildirMessageName.FILTER_DELETED_MESSAGES, from, to, -1);
            }
        }
        HashMap<MessageUid, MessageMetaData> uids = new HashMap<MessageUid, MessageMetaData>();
        for (MailboxMessage mailboxMessage : results) {
            MessageUid uid = mailboxMessage.getUid();
            uids.put(uid, (MessageMetaData)new SimpleMessageMetaData(mailboxMessage));
            this.delete(mailbox, mailboxMessage);
        }
        return uids;
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        throw new UnsupportedOperationException("Not implemented - see https://issues.apache.org/jira/browse/IMAP-370");
    }

    protected MessageMetaData copy(Mailbox mailbox, MessageUid uid, long modSeq, MailboxMessage original) throws MailboxException {
        SimpleMailboxMessage theCopy = SimpleMailboxMessage.copyWithoutAttachments((MailboxId)mailbox.getMailboxId(), (MailboxMessage)original);
        Flags flags = theCopy.createFlags();
        flags.add(Flags.Flag.RECENT);
        theCopy.setFlags(flags);
        return this.save(mailbox, (MailboxMessage)theCopy);
    }

    protected MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        MessageUid uid = MessageUid.MIN_VALUE;
        File tmpFolder = folder.getTmpFolder();
        MaildirMessageName messageName = MaildirMessageName.createUniqueName(folder, message.getFullContentOctets());
        File messageFile = new File(tmpFolder, messageName.getFullName());
        try {
            if (!messageFile.createNewFile()) {
                throw new IOException("Could not create file " + messageFile);
            }
            try (FileOutputStream fos = new FileOutputStream(messageFile);
                 InputStream input = message.getFullContent();){
                byte[] b = new byte[2048];
                int len = 0;
                while ((len = input.read(b)) != -1) {
                    fos.write(b, 0, len);
                }
            }
        }
        catch (IOException ioe) {
            throw new MailboxException("Failure while save MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)ioe);
        }
        File newMessageFile = null;
        if (message.isRecent()) {
            messageName.setFlags(message.createFlags());
            newMessageFile = new File(folder.getNewFolder(), messageName.getFullName());
        } else {
            messageName.setFlags(message.createFlags());
            newMessageFile = new File(folder.getCurFolder(), messageName.getFullName());
        }
        try {
            FileUtils.moveFile((File)messageFile, (File)newMessageFile);
        }
        catch (IOException e) {
            throw new MailboxException("Failure while save MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)e);
        }
        try {
            uid = folder.appendMessage(this.mailboxSession, newMessageFile.getName());
            message.setUid(uid);
            message.setModSeq(newMessageFile.lastModified());
            return new SimpleMessageMetaData(message);
        }
        catch (MailboxException e) {
            throw new MailboxException("Failure while save MailboxMessage " + message + " in Mailbox " + mailbox, (Throwable)e);
        }
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        int maxValue = -1;
        return new ApplicableFlagCalculator(this.findMessagesInMailboxBetweenUIDs(mailbox, null, MessageUid.MIN_VALUE, null, maxValue)).computeApplicableFlags();
    }

    public void endRequest() {
    }

    private List<MailboxMessage> findMessageInMailboxWithUID(Mailbox mailbox, MessageUid from) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            MaildirMessageName messageName = folder.getMessageNameByUid(this.mailboxSession, from);
            ArrayList<MailboxMessage> messages = new ArrayList<MailboxMessage>();
            if (messageName != null && messageName.getFile().exists()) {
                messages.add((MailboxMessage)new MaildirMailboxMessage(mailbox, from, messageName));
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for MailboxMessage with uid " + from + " in Mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findMessagesInMailboxBetweenUIDs(Mailbox mailbox, FilenameFilter filter, MessageUid from, MessageUid to, int max) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        int cur = 0;
        SortedMap<MessageUid, MaildirMessageName> uidMap = null;
        try {
            uidMap = filter != null ? folder.getUidMap(this.mailboxSession, filter, from, to) : folder.getUidMap(this.mailboxSession, from, to);
            ArrayList<MailboxMessage> messages = new ArrayList<MailboxMessage>();
            for (Map.Entry<MessageUid, MaildirMessageName> entry : uidMap.entrySet()) {
                messages.add((MailboxMessage)new MaildirMailboxMessage(mailbox, entry.getKey(), entry.getValue()));
                if (max == -1 || ++cur < max) continue;
                break;
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findMessagesInMailbox(Mailbox mailbox, FilenameFilter filter, int limit) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            SortedMap<MessageUid, MaildirMessageName> uidMap = folder.getUidMap(this.mailboxSession, filter, limit);
            ArrayList<MailboxMessage> filtered = new ArrayList<MailboxMessage>(uidMap.size());
            for (Map.Entry<MessageUid, MaildirMessageName> entry : uidMap.entrySet()) {
                filtered.add((MailboxMessage)new MaildirMailboxMessage(mailbox, entry.getKey(), entry.getValue()));
            }
            return filtered;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findDeletedMessageInMailboxWithUID(Mailbox mailbox, MessageUid uid) throws MailboxException {
        MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
        try {
            MaildirMessageName messageName = folder.getMessageNameByUid(this.mailboxSession, uid);
            ArrayList<MailboxMessage> messages = new ArrayList<MailboxMessage>();
            if (MaildirMessageName.FILTER_DELETED_MESSAGES.accept(null, messageName.getFullName())) {
                messages.add((MailboxMessage)new MaildirMailboxMessage(mailbox, uid, messageName));
            }
            return messages;
        }
        catch (IOException e) {
            throw new MailboxException("Failure while search for Messages in Mailbox " + mailbox, (Throwable)e);
        }
    }

    protected void begin() throws MailboxException {
    }

    protected void commit() throws MailboxException {
    }

    protected void rollback() throws MailboxException {
    }
}

