/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import java.util.ArrayList;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.maildir.MaildirId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;

public class MailboxCache {
    private final ArrayList<Mailbox> mailboxCache = new ArrayList();

    public synchronized Mailbox cacheMailbox(Mailbox mailbox) {
        this.mailboxCache.add((Mailbox)new SimpleMailbox(mailbox));
        int id = this.mailboxCache.size() - 1;
        mailbox.setMailboxId((MailboxId)MaildirId.of(id));
        return mailbox;
    }

    public synchronized Mailbox getCachedMailbox(MaildirId mailboxId) throws MailboxNotFoundException {
        if (mailboxId == null) {
            throw new MailboxNotFoundException("null");
        }
        try {
            return this.mailboxCache.get(mailboxId.getRawId());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MailboxNotFoundException((MailboxId)mailboxId);
        }
    }

    public synchronized void clear() {
        this.mailboxCache.clear();
    }
}

