/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;

public class MaildirStore
implements UidProvider,
ModSeqProvider {
    public static final String PATH_USER = "%user";
    public static final String PATH_DOMAIN = "%domain";
    public static final String PATH_FULLUSER = "%fulluser";
    public static final String WILDCARD = "%";
    public static final String maildirDelimiter = ".";
    private final String maildirLocation;
    private File maildirRootFile;
    private final MailboxPathLocker locker;
    private boolean messageNameStrictParse = false;

    public MaildirStore(String maildirLocation, MailboxPathLocker locker) {
        this.maildirLocation = maildirLocation;
        this.locker = locker;
    }

    public MaildirStore(String maildirLocation) {
        this(maildirLocation, (MailboxPathLocker)new JVMMailboxPathLocker());
    }

    public String getMaildirLocation() {
        return this.maildirLocation;
    }

    public MaildirFolder createMaildirFolder(Mailbox mailbox) {
        MaildirFolder mf = new MaildirFolder(this.getFolderName(mailbox), mailbox.generateAssociatedPath(), this.locker);
        mf.setMessageNameStrictParse(this.isMessageNameStrictParse());
        return mf;
    }

    public Mailbox loadMailbox(MailboxSession session, File root, String namespace, String user, String folderName) throws MailboxException {
        String mailboxName = this.getMailboxNameFromFolderName(folderName);
        return this.loadMailbox(session, new File(root, folderName), new MailboxPath(namespace, user, mailboxName));
    }

    public Mailbox loadMailbox(MailboxSession session, MailboxPath mailboxPath) throws MailboxNotFoundException, MailboxException {
        MaildirFolder folder = new MaildirFolder(this.getFolderName(mailboxPath), mailboxPath, this.locker);
        folder.setMessageNameStrictParse(this.isMessageNameStrictParse());
        if (!folder.exists()) {
            throw new MailboxNotFoundException(mailboxPath);
        }
        return this.loadMailbox(session, folder.getRootFile(), mailboxPath);
    }

    private Mailbox loadMailbox(MailboxSession session, File mailboxFile, MailboxPath mailboxPath) throws MailboxException {
        MaildirFolder folder = new MaildirFolder(mailboxFile.getAbsolutePath(), mailboxPath, this.locker);
        folder.setMessageNameStrictParse(this.isMessageNameStrictParse());
        try {
            SimpleMailbox loadedMailbox = new SimpleMailbox(mailboxPath, folder.getUidValidity());
            loadedMailbox.setACL(folder.getACL(session));
            return loadedMailbox;
        }
        catch (IOException e) {
            throw new MailboxException("Unable to load Mailbox " + mailboxPath, (Throwable)e);
        }
    }

    public String userRoot(String user) {
        String path = this.maildirLocation.replace(PATH_FULLUSER, user);
        String[] userParts = user.split("@");
        String userName = user;
        if (userParts.length == 2) {
            userName = userParts[0];
            path = path.replace(PATH_DOMAIN, userParts[1].toLowerCase(Locale.US));
        }
        path = path.replace(PATH_USER, userName);
        return path;
    }

    public File getMailboxRootForUser(String user) throws MailboxException {
        String path = this.userRoot(user);
        File root = new File(path);
        if (!root.isDirectory()) {
            throw new MailboxException("Unable to load Mailbox for user " + user);
        }
        return root;
    }

    public File getMaildirRoot() {
        if (this.maildirRootFile == null) {
            String maildirRootLocation = this.maildirLocation.replaceAll(PATH_FULLUSER, "");
            maildirRootLocation = maildirRootLocation.replaceAll(PATH_DOMAIN, "");
            maildirRootLocation = maildirRootLocation.replaceAll(PATH_USER, "");
            this.maildirRootFile = new File(maildirRootLocation);
        }
        return this.maildirRootFile;
    }

    public String getMailboxNameFromFolderName(String folderName) {
        String mName = folderName.equals("") ? "INBOX" : folderName.substring(1);
        return mName;
    }

    public String getFolderName(String namespace, String user, String name) {
        String root = this.userRoot(user);
        if (name.equals("INBOX")) {
            return root;
        }
        StringBuilder folder = new StringBuilder(root);
        if (!root.endsWith(File.pathSeparator)) {
            folder.append(File.separator);
        }
        folder.append(maildirDelimiter);
        folder.append(name);
        return folder.toString();
    }

    public String getFolderName(Mailbox mailbox) {
        return this.getFolderName(mailbox.getNamespace(), mailbox.getUser(), mailbox.getName());
    }

    public String getFolderName(MailboxPath mailboxPath) {
        return this.getFolderName(mailboxPath.getNamespace(), mailboxPath.getUser(), mailboxPath.getName());
    }

    public MessageUid nextUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try {
            return this.createMaildirFolder(mailbox).getLastUid(session).map(MessageUid::next).orElse(MessageUid.MIN_VALUE);
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to generate next uid", (Throwable)e);
        }
    }

    public long nextModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        return System.currentTimeMillis();
    }

    public long highestModSeq(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try {
            return this.createMaildirFolder(mailbox).getHighestModSeq();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to get highest mod-sequence for mailbox", (Throwable)e);
        }
    }

    public Optional<MessageUid> lastUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        return this.createMaildirFolder(mailbox).getLastUid(session);
    }

    public boolean isMessageNameStrictParse() {
        return this.messageNameStrictParse;
    }

    public void setMessageNameStrictParse(boolean messageNameStrictParse) {
        this.messageNameStrictParse = messageNameStrictParse;
    }

    public long nextModSeq(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        return System.currentTimeMillis();
    }

    public MessageUid nextUid(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        throw new NotImplementedException("Not implemented");
    }

    public long highestModSeq(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        throw new NotImplementedException("Not implemented");
    }
}

