/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaValue;

public class QuotaCount
implements QuotaValue<QuotaCount> {
    private final Optional<Long> value;

    public static QuotaCount unlimited() {
        return new QuotaCount(Optional.empty());
    }

    public static QuotaCount count(long value) {
        return QuotaCount.count(Optional.of(value));
    }

    public static QuotaCount count(Optional<Long> value) {
        return new QuotaCount(value);
    }

    private QuotaCount(Optional<Long> value) {
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value.orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean isLimited() {
        return this.value.isPresent();
    }

    @Override
    public QuotaCount add(long additionalValue) {
        return new QuotaCount(this.value.map(x -> x + additionalValue));
    }

    @Override
    public QuotaCount add(QuotaCount additionalValue) {
        if (additionalValue.isUnlimited()) {
            return QuotaCount.unlimited();
        }
        return new QuotaCount(this.value.map(x -> x + additionalValue.asLong()));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value.map(String::valueOf).orElse("unlimited")).toString();
    }

    @Override
    public boolean isGreaterThan(QuotaCount other) {
        return this.value.orElse(Long.MAX_VALUE) > other.value.orElse(Long.MAX_VALUE);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaCount) {
            QuotaCount that = (QuotaCount)o;
            return Objects.equal(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

