/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.healthcheck;

import java.util.Optional;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.ResultStatus;

public class Result {
    private final ComponentName componentName;
    private final ResultStatus status;
    private final Optional<String> cause;

    public static Result healthy(ComponentName componentName) {
        return new Result(componentName, ResultStatus.HEALTHY, Optional.empty());
    }

    public static Result unhealthy(ComponentName componentName, String cause) {
        return new Result(componentName, ResultStatus.UNHEALTHY, Optional.of(cause));
    }

    public static Result unhealthy(ComponentName componentName) {
        return new Result(componentName, ResultStatus.UNHEALTHY, Optional.empty());
    }

    public static Result degraded(ComponentName componentName, String cause) {
        return new Result(componentName, ResultStatus.DEGRADED, Optional.of(cause));
    }

    public static Result degraded(ComponentName componentName) {
        return new Result(componentName, ResultStatus.DEGRADED, Optional.empty());
    }

    private Result(ComponentName componentName, ResultStatus status, Optional<String> cause) {
        this.componentName = componentName;
        this.status = status;
        this.cause = cause;
    }

    public ComponentName getComponentName() {
        return this.componentName;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public boolean isHealthy() {
        return this.status == ResultStatus.HEALTHY;
    }

    public boolean isDegraded() {
        return this.status == ResultStatus.DEGRADED;
    }

    public boolean isUnHealthy() {
        return this.status == ResultStatus.UNHEALTHY;
    }

    public Optional<String> getCause() {
        return this.cause;
    }
}

