/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;

public class MaybeSender {
    private final Optional<MailAddress> mailAddress;

    public static MaybeSender nullSender() {
        return new MaybeSender(Optional.empty());
    }

    public static MaybeSender of(MailAddress mailAddress) {
        return new MaybeSender(Optional.ofNullable(mailAddress).filter(address -> !address.isNullSender()));
    }

    private MaybeSender(Optional<MailAddress> mailAddress) {
        this.mailAddress = mailAddress;
    }

    public Optional<MailAddress> asOptional() {
        return this.mailAddress;
    }

    public Stream<MailAddress> asStream() {
        return this.mailAddress.map(Stream::of).orElse(Stream.of(new MailAddress[0]));
    }

    public ImmutableList<MailAddress> asList() {
        return this.mailAddress.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    public MailAddress get() throws NoSuchElementException {
        return this.mailAddress.get();
    }

    public String asString() {
        return this.asString("<>");
    }

    public String asPrettyString() {
        return this.mailAddress.map(MailAddress::asPrettyString).orElse("<>");
    }

    public boolean isNullSender() {
        return !this.mailAddress.isPresent();
    }

    public String asString(String forNullValue) {
        return this.mailAddress.map(MailAddress::asString).orElse(forNullValue);
    }

    public final boolean equals(Object o) {
        if (o instanceof MaybeSender) {
            MaybeSender that = (MaybeSender)o;
            return Objects.equals(this.mailAddress, that.mailAddress);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailAddress", this.mailAddress).toString();
    }
}

