/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.mail;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import org.apache.james.javax.MimeMultipartReport;
import org.apache.mailet.base.mail.AbstractDataContentHandler;

public class MultipartReport
extends AbstractDataContentHandler {
    @Override
    protected ActivationDataFlavor computeDataFlavor() {
        return new ActivationDataFlavor(MimeMultipartReport.class, "multipart/report", "Multipart Report");
    }

    public void writeTo(Object aPart, String aMimeType, OutputStream aStream) throws IOException {
        if (!(aPart instanceof MimeMultipartReport)) {
            throw new IOException("Type \"" + aPart.getClass().getName() + "\" is not supported.");
        }
        try {
            ((MimeMultipartReport)aPart).writeTo(aStream);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected Object computeContent(DataSource aDataSource) throws MessagingException {
        return new MimeMultipartReport(aDataSource);
    }
}

