/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.imap.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.imap.decode.ImapRequestLineReader;

public class EolInputStream
extends FilterInputStream {
    private final ImapRequestLineReader reader;
    private boolean eolCalled = false;

    public EolInputStream(ImapRequestLineReader reader, InputStream in) {
        super(in);
        this.reader = reader;
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        this.eol(i);
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        this.eol(i);
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = this.in.read(b);
        this.eol(i);
        return i;
    }

    private void eol(int i) throws IOException {
        if (i == -1 && !this.eolCalled) {
            this.reader.eol();
            this.eolCalled = true;
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }
}

