/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.main;

import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;
import org.apache.james.imap.processor.DefaultProcessorChain;
import org.apache.james.imap.processor.base.ImapResponseMessageProcessor;
import org.apache.james.imap.processor.base.UnknownRequestProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;

public class DefaultImapProcessorFactory {
    private MailboxManager mailboxManager;
    private SubscriptionManager subscriptionManager;
    private MailboxTyper mailboxTyper;
    private QuotaManager quotaManager;
    private QuotaRootResolver quotaRootResolver;
    private MetricFactory metricFactory;

    public static ImapProcessor createDefaultProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        return DefaultImapProcessorFactory.createXListSupportingProcessor(mailboxManager, subscriptionManager, null, quotaManager, quotaRootResolver, metricFactory);
    }

    public static ImapProcessor createXListSupportingProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxTyper mailboxTyper, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        UnpooledStatusResponseFactory statusResponseFactory = new UnpooledStatusResponseFactory();
        UnknownRequestProcessor unknownRequestImapProcessor = new UnknownRequestProcessor(statusResponseFactory);
        ImapProcessor imap4rev1Chain = DefaultProcessorChain.createDefaultChain(unknownRequestImapProcessor, mailboxManager, subscriptionManager, statusResponseFactory, mailboxTyper, quotaManager, quotaRootResolver, metricFactory);
        return new ImapResponseMessageProcessor(imap4rev1Chain);
    }

    public final void setMailboxManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public final void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public void setMailboxTyper(MailboxTyper mailboxTyper) {
        this.mailboxTyper = mailboxTyper;
    }

    public void setQuotaManager(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }

    public void setQuotaRootResolver(QuotaRootResolver quotaRootResolver) {
        this.quotaRootResolver = quotaRootResolver;
    }

    public final MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public final SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public MailboxTyper getMailboxTyper() {
        return this.mailboxTyper;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public QuotaRootResolver getQuotaRootResolver() {
        return this.quotaRootResolver;
    }

    public MetricFactory getMetricFactory() {
        return this.metricFactory;
    }

    public void setMetricFactory(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public ImapProcessor buildImapProcessor() {
        return DefaultImapProcessorFactory.createDefaultProcessor(this.mailboxManager, this.subscriptionManager, this.quotaManager, this.quotaRootResolver, this.metricFactory);
    }
}

