/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.message.request.ExamineRequest;
import org.apache.james.imap.processor.AbstractSelectionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class ExamineProcessor
extends AbstractSelectionProcessor<ExamineRequest> {
    public ExamineProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory) {
        super(ExamineRequest.class, next, mailboxManager, statusResponseFactory, true, metricFactory);
    }

    @Override
    protected Closeable addContextToMDC(ExamineRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"EXAMINE").addContext("mailbox", (Object)message.getMailboxName()).addContext("condstore", (Object)Boolean.toString(message.getCondstore())).addContext("knownModseq", (Object)message.getKnownModSeq()).addContext("knownUids", (Object)UidRange.toString(message.getKnownUidSet())).addContext("knownIdRange", (Object)IdRange.toString(message.getKnownSequenceSet())).addContext("lastKnownUidValidity", (Object)message.getLastKnownUidValidity()).addContext("uidSet", (Object)UidRange.toString(message.getUidSet())).build();
    }
}

