/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.DeleteACLRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteACLProcessor
extends AbstractMailboxProcessor<DeleteACLRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteACLProcessor.class);
    private static final List<String> CAPABILITIES = ImmutableList.of((Object)"ACL");

    public DeleteACLProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(DeleteACLRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(DeleteACLRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        String identifier = message.getIdentifier();
        try {
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            mailboxManager.getMailbox(mailboxPath, mailboxSession);
            if (!mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Lookup, mailboxSession)) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else if (!mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Administer, mailboxSession)) {
                Object[] params = new Object[]{MailboxACL.Right.Administer.toString(), command.getName(), mailboxName};
                HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, text);
            } else {
                MailboxACL.EntryKey key = MailboxACL.EntryKey.deserialize((String)identifier);
                mailboxManager.applyRightsCommand(mailboxPath, MailboxACL.command().key(key).noRights().asReplacement(), mailboxSession);
                this.okComplete(command, tag, responder);
            }
        }
        catch (UnsupportedRightException e) {
            Object[] params = new Object[]{Character.valueOf(e.getUnsupportedRight())};
            HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUPPORTED_RIGHT", "The {0} right is not supported.", params);
            this.taggedBad(command, tag, responder, text);
        }
        catch (MailboxNotFoundException e) {
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            LOGGER.error("{} failed for mailbox {}", new Object[]{command.getName(), mailboxName, e});
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Closeable addContextToMDC(DeleteACLRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"DELETE_ACL").addContext("mailbox", (Object)message.getMailboxName()).addContext("identifier", (Object)message.getIdentifier()).build();
    }
}

