/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.main;

import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.encode.ACLResponseEncoder;
import org.apache.james.imap.encode.AnnotationResponseEncoder;
import org.apache.james.imap.encode.AuthenticateResponseEncoder;
import org.apache.james.imap.encode.CapabilityResponseEncoder;
import org.apache.james.imap.encode.ContinuationResponseEncoder;
import org.apache.james.imap.encode.ESearchResponseEncoder;
import org.apache.james.imap.encode.EnableResponseEncoder;
import org.apache.james.imap.encode.ExistsResponseEncoder;
import org.apache.james.imap.encode.ExpungeResponseEncoder;
import org.apache.james.imap.encode.FetchResponseEncoder;
import org.apache.james.imap.encode.FlagsResponseEncoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapEncoderFactory;
import org.apache.james.imap.encode.LSubResponseEncoder;
import org.apache.james.imap.encode.ListResponseEncoder;
import org.apache.james.imap.encode.ListRightsResponseEncoder;
import org.apache.james.imap.encode.MailboxStatusResponseEncoder;
import org.apache.james.imap.encode.MyRightsResponseEncoder;
import org.apache.james.imap.encode.NamespaceResponseEncoder;
import org.apache.james.imap.encode.QuotaResponseEncoder;
import org.apache.james.imap.encode.QuotaRootResponseEncoder;
import org.apache.james.imap.encode.RecentResponseEncoder;
import org.apache.james.imap.encode.SearchResponseEncoder;
import org.apache.james.imap.encode.StatusResponseEncoder;
import org.apache.james.imap.encode.VanishedResponseEncoder;
import org.apache.james.imap.encode.XListResponseEncoder;
import org.apache.james.imap.encode.base.EndImapEncoder;
import org.apache.james.imap.encode.main.DefaultLocalizer;

public class DefaultImapEncoderFactory
implements ImapEncoderFactory {
    private final Localizer localizer;
    private final boolean neverAddBodyStructureExtensions;

    public static final ImapEncoder createDefaultEncoder(Localizer localizer, boolean neverAddBodyStructureExtensions) {
        EndImapEncoder endImapEncoder = new EndImapEncoder();
        AnnotationResponseEncoder annotationResponseEncoder = new AnnotationResponseEncoder(endImapEncoder);
        MyRightsResponseEncoder myRightsResponseEncoder = new MyRightsResponseEncoder(annotationResponseEncoder);
        ListRightsResponseEncoder listRightsResponseEncoder = new ListRightsResponseEncoder(myRightsResponseEncoder);
        ACLResponseEncoder aclResponseEncoder = new ACLResponseEncoder(listRightsResponseEncoder);
        NamespaceResponseEncoder namespaceEncoder = new NamespaceResponseEncoder(aclResponseEncoder);
        StatusResponseEncoder statusResponseEncoder = new StatusResponseEncoder(namespaceEncoder, localizer);
        RecentResponseEncoder recentResponseEncoder = new RecentResponseEncoder(statusResponseEncoder);
        FetchResponseEncoder fetchResponseEncoder = new FetchResponseEncoder(recentResponseEncoder, neverAddBodyStructureExtensions);
        ExpungeResponseEncoder expungeResponseEncoder = new ExpungeResponseEncoder(fetchResponseEncoder);
        ExistsResponseEncoder existsResponseEncoder = new ExistsResponseEncoder(expungeResponseEncoder);
        MailboxStatusResponseEncoder statusCommandResponseEncoder = new MailboxStatusResponseEncoder(existsResponseEncoder);
        SearchResponseEncoder searchResponseEncoder = new SearchResponseEncoder(statusCommandResponseEncoder);
        LSubResponseEncoder lsubResponseEncoder = new LSubResponseEncoder(searchResponseEncoder);
        ListResponseEncoder listResponseEncoder = new ListResponseEncoder(lsubResponseEncoder);
        XListResponseEncoder xListResponseEncoder = new XListResponseEncoder(listResponseEncoder);
        FlagsResponseEncoder flagsResponseEncoder = new FlagsResponseEncoder(xListResponseEncoder);
        CapabilityResponseEncoder capabilityResponseEncoder = new CapabilityResponseEncoder(flagsResponseEncoder);
        EnableResponseEncoder enableResponseEncoder = new EnableResponseEncoder(capabilityResponseEncoder);
        ContinuationResponseEncoder continuationResponseEncoder = new ContinuationResponseEncoder(enableResponseEncoder, localizer);
        AuthenticateResponseEncoder authResponseEncoder = new AuthenticateResponseEncoder(continuationResponseEncoder);
        ESearchResponseEncoder esearchResponseEncoder = new ESearchResponseEncoder(authResponseEncoder);
        VanishedResponseEncoder vanishedResponseEncoder = new VanishedResponseEncoder(esearchResponseEncoder);
        QuotaResponseEncoder quotaResponseEncoder = new QuotaResponseEncoder(vanishedResponseEncoder);
        QuotaRootResponseEncoder quotaRootResponseEncoder = new QuotaRootResponseEncoder(quotaResponseEncoder);
        return quotaRootResponseEncoder;
    }

    public DefaultImapEncoderFactory() {
        this(new DefaultLocalizer(), false);
    }

    public DefaultImapEncoderFactory(Localizer localizer, boolean neverAddBodyStructureExtensions) {
        this.localizer = localizer;
        this.neverAddBodyStructureExtensions = neverAddBodyStructureExtensions;
    }

    @Override
    public ImapEncoder buildImapEncoder() {
        return DefaultImapEncoderFactory.createDefaultEncoder(this.localizer, this.neverAddBodyStructureExtensions);
    }
}

