/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.base;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.CharsetUtil;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.response.Literal;
import org.apache.james.protocols.imap.utils.FastByteArrayOutputStream;

public class ImapResponseComposerImpl
implements ImapConstants,
ImapResponseComposer {
    public static final String FLAGS = "FLAGS";
    public static final String FAILED = "failed.";
    private static final int LOWER_CASE_OFFSET = 32;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private final ImapResponseWriter writer;
    private final FastByteArrayOutputStream buffer;
    private final Charset usAscii = Charset.forName("US-ASCII");
    private boolean skipNextSpace = false;

    public ImapResponseComposerImpl(ImapResponseWriter writer, int bufferSize) {
        this.writer = writer;
        this.buffer = new FastByteArrayOutputStream(bufferSize);
    }

    public ImapResponseComposerImpl(ImapResponseWriter writer) {
        this(writer, 2048);
    }

    @Override
    public ImapResponseComposer untaggedNoResponse(String displayMessage, String responseCode) throws IOException {
        this.untagged();
        this.message("NO");
        this.responseCode(responseCode);
        this.message(displayMessage);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer continuationResponse(String message) throws IOException {
        this.writeASCII("+ " + message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer commandResponse(ImapCommand command, String message) throws IOException {
        this.untagged();
        this.commandName(command.getName());
        this.message(message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer taggedResponse(String message, String tag) throws IOException {
        this.tag(tag);
        this.message(message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer untaggedResponse(String message) throws IOException {
        this.untagged();
        this.message(message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer untagged() throws IOException {
        this.writeASCII("*");
        return this;
    }

    @Override
    public ImapResponseComposer message(String message) throws IOException {
        if (message != null) {
            this.space();
            this.writeASCII(message);
        }
        return this;
    }

    private void responseCode(String responseCode) throws IOException {
        if (responseCode != null && !"".equals(responseCode)) {
            this.writeASCII(" [");
            this.writeASCII(responseCode);
            this.buffer.write(93);
        }
    }

    @Override
    public ImapResponseComposer end() throws IOException {
        this.buffer.write("\r\n".getBytes());
        this.writer.write(this.buffer.toByteArray());
        this.buffer.reset();
        return this;
    }

    @Override
    public ImapResponseComposer tag(String tag) throws IOException {
        this.writeASCII(tag);
        return this;
    }

    @Override
    public ImapResponseComposer closeParen() throws IOException {
        this.closeBracket((byte)41);
        return this;
    }

    @Override
    public ImapResponseComposer openParen() throws IOException {
        this.openBracket((byte)40);
        return this;
    }

    @Override
    public ImapResponseComposer flags(Flags flags) throws IOException {
        String[] userFlags;
        this.message(FLAGS);
        this.openParen();
        if (flags.contains(Flags.Flag.ANSWERED)) {
            this.message("\\Answered");
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            this.message("\\Deleted");
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            this.message("\\Draft");
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            this.message("\\Flagged");
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            this.message("\\Recent");
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            this.message("\\Seen");
        }
        for (String userFlag : userFlags = flags.getUserFlags()) {
            this.message(userFlag);
        }
        this.closeParen();
        return this;
    }

    @Override
    public ImapResponseComposer nil() throws IOException {
        this.message("NIL");
        return this;
    }

    @Override
    public ImapResponseComposer upperCaseAscii(String message) throws IOException {
        if (message == null) {
            this.nil();
        } else {
            this.upperCaseAscii(message, false);
        }
        return this;
    }

    @Override
    public ImapResponseComposer quoteUpperCaseAscii(String message) throws IOException {
        if (message == null) {
            this.nil();
        } else {
            this.upperCaseAscii(message, true);
        }
        return this;
    }

    private void writeASCII(String string) throws IOException {
        this.buffer.write(string.getBytes(this.usAscii));
    }

    @Override
    public ImapResponseComposer message(long number) throws IOException {
        this.space();
        this.writeASCII(Long.toString(number));
        return this;
    }

    @Override
    public ImapResponseComposer mailbox(String mailboxName) throws IOException {
        this.quote(CharsetUtil.encodeModifiedUTF7(mailboxName));
        return this;
    }

    @Override
    public ImapResponseComposer commandName(String commandName) throws IOException {
        this.space();
        this.writeASCII(commandName);
        return this;
    }

    @Override
    public ImapResponseComposer quote(String message) throws IOException {
        this.space();
        int length = message.length();
        this.buffer.write(34);
        for (int i = 0; i < length; ++i) {
            char character = message.charAt(i);
            if (character == '\\' || character == '\"') {
                this.buffer.write(92);
            }
            if (character > '\u0080') {
                this.buffer.write(63);
                continue;
            }
            this.buffer.write((byte)character);
        }
        this.buffer.write(34);
        return this;
    }

    private void closeBracket(byte bracket) throws IOException {
        this.buffer.write(bracket);
        this.clearSkipNextSpace();
    }

    private void openBracket(byte bracket) throws IOException {
        this.space();
        this.buffer.write(bracket);
        this.skipNextSpace();
    }

    private void clearSkipNextSpace() {
        this.skipNextSpace = false;
    }

    @Override
    public ImapResponseComposer skipNextSpace() {
        this.skipNextSpace = true;
        return this;
    }

    private void space() throws IOException {
        if (this.skipNextSpace) {
            this.skipNextSpace = false;
        } else {
            this.buffer.write(" ".getBytes());
        }
    }

    @Override
    public ImapResponseComposer literal(Literal literal) throws IOException {
        this.space();
        this.buffer.write(123);
        long size = literal.size();
        this.writeASCII(Long.toString(size));
        this.buffer.write(125);
        this.end();
        if (size > 0L) {
            this.writer.write(literal);
        }
        return this;
    }

    @Override
    public ImapResponseComposer closeSquareBracket() throws IOException {
        this.closeBracket((byte)93);
        return this;
    }

    @Override
    public ImapResponseComposer openSquareBracket() throws IOException {
        this.openBracket((byte)91);
        return this;
    }

    private void upperCaseAscii(String message, boolean quote) throws IOException {
        this.space();
        int length = message.length();
        if (quote) {
            this.buffer.write(34);
        }
        for (int i = 0; i < length; ++i) {
            char next = message.charAt(i);
            if (next >= 'a' && next <= 'z') {
                this.buffer.write((byte)(next - 32));
                continue;
            }
            this.buffer.write((byte)next);
        }
        if (quote) {
            this.buffer.write(34);
        }
    }

    @Override
    public ImapResponseComposer sequenceSet(UidRange[] ranges) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; ++i) {
            UidRange range = ranges[i];
            sb.append(range.getFormattedString());
            if (i + 1 >= ranges.length) continue;
            sb.append(",");
        }
        return this.message(sb.toString());
    }

    @Override
    public ImapResponseComposer sequenceSet(IdRange[] ranges) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; ++i) {
            IdRange range = ranges[i];
            sb.append(range.getFormattedString());
            if (i + 1 >= ranges.length) continue;
            sb.append(",");
        }
        return this.message(sb.toString());
    }
}

