/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Map;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.ACLResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class ACLResponseEncoder
extends AbstractChainedImapEncoder {
    public ACLResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        ACLResponse aclResponse = (ACLResponse)acceptableMessage;
        Map entries = aclResponse.getAcl().getEntries();
        composer.untagged();
        composer.commandName("ACL");
        String mailboxName = aclResponse.getMailboxName();
        composer.mailbox(mailboxName == null ? "" : mailboxName);
        if (entries != null) {
            for (Map.Entry entry : entries.entrySet()) {
                String identifier = ((MailboxACL.EntryKey)entry.getKey()).serialize();
                composer.quote(identifier);
                String rights = ((MailboxACL.Rfc4314Rights)entry.getValue()).serialize();
                composer.quote(rights == null ? "" : rights);
            }
        }
        composer.end();
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof ACLResponse;
    }
}

