/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.SetQuotaRequest;
import org.apache.james.protocols.imap.DecodingException;

public class SetQuotaCommandParser
extends AbstractImapCommandParser {
    public SetQuotaCommandParser() {
        super(ImapCommand.authenticatedStateCommand("SETQUOTA"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        String quotaRoot = request.atom();
        SetQuotaRequest setQuotaRequest = new SetQuotaRequest(tag, command, quotaRoot);
        request.nextWordChar();
        while (request.nextChar() == '(') {
            request.consume();
            String resource = request.atom();
            request.nextWordChar();
            long limit = request.number(true);
            request.nextWordChar();
            request.consumeChar(')');
            setQuotaRequest.addResourceLimit(resource, limit);
            while (request.nextChar() == ' ') {
                request.consume();
            }
        }
        request.eol();
        return setQuotaRequest;
    }
}

