/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.decode.DelegatingImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.MessagingImapCommandParser;
import org.apache.james.imap.decode.parser.AppendCommandParser;
import org.apache.james.imap.decode.parser.AuthenticateCommandParser;
import org.apache.james.imap.decode.parser.CapabilityCommandParser;
import org.apache.james.imap.decode.parser.CheckCommandParser;
import org.apache.james.imap.decode.parser.CloseCommandParser;
import org.apache.james.imap.decode.parser.CompressCommandParser;
import org.apache.james.imap.decode.parser.CopyCommandParser;
import org.apache.james.imap.decode.parser.CreateCommandParser;
import org.apache.james.imap.decode.parser.DeleteACLCommandParser;
import org.apache.james.imap.decode.parser.DeleteCommandParser;
import org.apache.james.imap.decode.parser.EnableCommandParser;
import org.apache.james.imap.decode.parser.ExamineCommandParser;
import org.apache.james.imap.decode.parser.ExpungeCommandParser;
import org.apache.james.imap.decode.parser.FetchCommandParser;
import org.apache.james.imap.decode.parser.GetACLCommandParser;
import org.apache.james.imap.decode.parser.GetAnnotationCommandParser;
import org.apache.james.imap.decode.parser.GetQuotaCommandParser;
import org.apache.james.imap.decode.parser.GetQuotaRootCommandParser;
import org.apache.james.imap.decode.parser.IdleCommandParser;
import org.apache.james.imap.decode.parser.ListCommandParser;
import org.apache.james.imap.decode.parser.ListRightsCommandParser;
import org.apache.james.imap.decode.parser.LoginCommandParser;
import org.apache.james.imap.decode.parser.LogoutCommandParser;
import org.apache.james.imap.decode.parser.LsubCommandParser;
import org.apache.james.imap.decode.parser.MoveCommandParser;
import org.apache.james.imap.decode.parser.MyRightsCommandParser;
import org.apache.james.imap.decode.parser.NamespaceCommandParser;
import org.apache.james.imap.decode.parser.NoopCommandParser;
import org.apache.james.imap.decode.parser.RenameCommandParser;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.apache.james.imap.decode.parser.SelectCommandParser;
import org.apache.james.imap.decode.parser.SetACLCommandParser;
import org.apache.james.imap.decode.parser.SetAnnotationCommandParser;
import org.apache.james.imap.decode.parser.SetQuotaCommandParser;
import org.apache.james.imap.decode.parser.StartTLSCommandParser;
import org.apache.james.imap.decode.parser.StatusCommandParser;
import org.apache.james.imap.decode.parser.StoreCommandParser;
import org.apache.james.imap.decode.parser.SubscribeCommandParser;
import org.apache.james.imap.decode.parser.UidCommandParser;
import org.apache.james.imap.decode.parser.UnselectCommandParser;
import org.apache.james.imap.decode.parser.UnsubscribeCommandParser;
import org.apache.james.imap.decode.parser.XListCommandParser;

public class ImapParserFactory
implements ImapCommandParserFactory {
    private final Map<String, Class<?>> imapCommands;
    private final StatusResponseFactory statusResponseFactory;

    public ImapParserFactory(StatusResponseFactory statusResponseFactory) {
        this.statusResponseFactory = statusResponseFactory;
        this.imapCommands = new HashMap();
        this.imapCommands.put("CAPABILITY", CapabilityCommandParser.class);
        this.imapCommands.put("NOOP", NoopCommandParser.class);
        this.imapCommands.put("LOGOUT", LogoutCommandParser.class);
        this.imapCommands.put("AUTHENTICATE", AuthenticateCommandParser.class);
        this.imapCommands.put("LOGIN", LoginCommandParser.class);
        this.imapCommands.put("SELECT", SelectCommandParser.class);
        this.imapCommands.put("EXAMINE", ExamineCommandParser.class);
        this.imapCommands.put("CREATE", CreateCommandParser.class);
        this.imapCommands.put("DELETE", DeleteCommandParser.class);
        this.imapCommands.put("RENAME", RenameCommandParser.class);
        this.imapCommands.put("SUBSCRIBE", SubscribeCommandParser.class);
        this.imapCommands.put("UNSUBSCRIBE", UnsubscribeCommandParser.class);
        this.imapCommands.put("LIST", ListCommandParser.class);
        this.imapCommands.put("XLIST", XListCommandParser.class);
        this.imapCommands.put("LSUB", LsubCommandParser.class);
        this.imapCommands.put("STATUS", StatusCommandParser.class);
        this.imapCommands.put("APPEND", AppendCommandParser.class);
        this.imapCommands.put("NAMESPACE", NamespaceCommandParser.class);
        this.imapCommands.put("GETACL", GetACLCommandParser.class);
        this.imapCommands.put("SETACL", SetACLCommandParser.class);
        this.imapCommands.put("DELETEACL", DeleteACLCommandParser.class);
        this.imapCommands.put("LISTRIGHTS", ListRightsCommandParser.class);
        this.imapCommands.put("MYRIGHTS", MyRightsCommandParser.class);
        this.imapCommands.put("CHECK", CheckCommandParser.class);
        this.imapCommands.put("CLOSE", CloseCommandParser.class);
        this.imapCommands.put("EXPUNGE", ExpungeCommandParser.class);
        this.imapCommands.put("COPY", CopyCommandParser.class);
        this.imapCommands.put("MOVE", MoveCommandParser.class);
        this.imapCommands.put("SEARCH", SearchCommandParser.class);
        this.imapCommands.put("FETCH", FetchCommandParser.class);
        this.imapCommands.put("STORE", StoreCommandParser.class);
        this.imapCommands.put("UID", UidCommandParser.class);
        this.imapCommands.put("IDLE", IdleCommandParser.class);
        this.imapCommands.put("STARTTLS", StartTLSCommandParser.class);
        this.imapCommands.put("UNSELECT", UnselectCommandParser.class);
        this.imapCommands.put("COMPRESS", CompressCommandParser.class);
        this.imapCommands.put("ENABLE", EnableCommandParser.class);
        this.imapCommands.put("GETQUOTAROOT", GetQuotaRootCommandParser.class);
        this.imapCommands.put("GETQUOTA", GetQuotaCommandParser.class);
        this.imapCommands.put("SETQUOTA", SetQuotaCommandParser.class);
        this.imapCommands.put("SETMETADATA", SetAnnotationCommandParser.class);
        this.imapCommands.put("GETMETADATA", GetAnnotationCommandParser.class);
    }

    @Override
    public ImapCommandParser getParser(String commandName) {
        Class<?> cmdClass = this.imapCommands.get(commandName.toUpperCase(Locale.US));
        if (cmdClass == null) {
            return null;
        }
        return this.createCommand(cmdClass);
    }

    private ImapCommandParser createCommand(Class<?> commandClass) {
        try {
            ImapCommandParser cmd = (ImapCommandParser)commandClass.newInstance();
            this.initialiseParser(cmd);
            return cmd;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create command instance: " + commandClass.getName(), e);
        }
    }

    protected void initialiseParser(ImapCommandParser cmd) {
        if (cmd instanceof DelegatingImapCommandParser) {
            ((DelegatingImapCommandParser)((Object)cmd)).setParserFactory(this);
        }
        if (cmd instanceof MessagingImapCommandParser) {
            MessagingImapCommandParser messagingImapCommandParser = (MessagingImapCommandParser)cmd;
            messagingImapCommandParser.setStatusResponseFactory(this.statusResponseFactory);
        }
    }
}

