/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.response.Literal;

public class OutputStreamImapResponseWriter
implements ImapResponseWriter {
    private final OutputStream output;

    public OutputStreamImapResponseWriter(OutputStream output) {
        this.output = output;
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Literal literal) throws IOException {
        try (InputStream in = null;){
            int len;
            in = literal.getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                this.output.write(buffer, 0, len);
            }
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.output.write(buffer);
    }
}

