/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public class BodyFetchElement {
    public static final int TEXT = 0;
    public static final int MIME = 1;
    public static final int HEADER = 2;
    public static final int HEADER_FIELDS = 3;
    public static final int HEADER_NOT_FIELDS = 4;
    public static final int CONTENT = 5;
    private static final BodyFetchElement rfc822 = new BodyFetchElement("RFC822", 5, null, null, null, null);
    private static final BodyFetchElement rfc822Header = new BodyFetchElement("RFC822.HEADER", 2, null, null, null, null);
    private static final BodyFetchElement rfc822Text = new BodyFetchElement("RFC822.TEXT", 0, null, null, null, null);
    private final Long firstOctet;
    private final Long numberOfOctets;
    private final String name;
    private final int sectionType;
    private final int[] path;
    private final Collection<String> fieldNames;

    public static final BodyFetchElement createRFC822() {
        return rfc822;
    }

    public static final BodyFetchElement createRFC822Header() {
        return rfc822Header;
    }

    public static final BodyFetchElement createRFC822Text() {
        return rfc822Text;
    }

    public BodyFetchElement(String name, int sectionType, int[] path, Collection<String> fieldNames, Long firstOctet, Long numberOfOctets) {
        this.name = name;
        this.sectionType = sectionType;
        this.fieldNames = fieldNames;
        this.path = path;
        this.firstOctet = firstOctet;
        this.numberOfOctets = numberOfOctets;
    }

    public String getResponseName() {
        return this.name;
    }

    public final Collection<String> getFieldNames() {
        return this.fieldNames;
    }

    public final int[] getPath() {
        return this.path;
    }

    public final int getSectionType() {
        return this.sectionType;
    }

    public final Long getFirstOctet() {
        return this.firstOctet;
    }

    public final Long getNumberOfOctets() {
        return this.numberOfOctets;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fieldNames == null ? 0 : this.fieldNames.hashCode());
        result = 31 * result + (this.firstOctet == null ? 0 : this.firstOctet.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.numberOfOctets == null ? 0 : this.numberOfOctets.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.length);
        result = 31 * result + this.sectionType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BodyFetchElement other = (BodyFetchElement)obj;
        if (this.fieldNames == null ? other.fieldNames != null : !this.fieldNames.equals(other.fieldNames)) {
            return false;
        }
        if (this.firstOctet == null ? other.firstOctet != null : !this.firstOctet.equals(other.firstOctet)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.numberOfOctets == null ? other.numberOfOctets != null : !this.numberOfOctets.equals(other.numberOfOctets)) {
            return false;
        }
        if (!Arrays.equals(this.path, other.path)) {
            return false;
        }
        return this.sectionType == other.sectionType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("firstOctet", (Object)this.firstOctet).add("numberOfOctets", (Object)this.numberOfOctets).add("name", (Object)this.name).add("sectionType", this.sectionType).add("fieldNames", Optional.ofNullable(this.fieldNames).map(ImmutableList::copyOf)).toString();
    }
}

