/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.configuration;

import java.io.File;
import java.util.Optional;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;

public class Configuration {
    public static final String WORKING_DIRECTORY = "working.directory";
    private final String configurationPath;
    private final JamesDirectoriesProvider directoriesProvider;

    public static Builder builder() {
        return new Builder();
    }

    private Configuration(String rootDirectory, String configurationPath) {
        this.configurationPath = configurationPath;
        this.directoriesProvider = new JamesServerResourceLoader(rootDirectory);
    }

    public String configurationPath() {
        return this.configurationPath;
    }

    public JamesDirectoriesProvider directories() {
        return this.directoriesProvider;
    }

    public static class Builder {
        private Optional<String> rootDirectory = Optional.empty();
        private Optional<String> configurationPath = Optional.empty();

        private Builder() {
        }

        public Builder workingDirectory(String path) {
            this.rootDirectory = Optional.of(path);
            return this;
        }

        public Builder workingDirectory(File file) {
            this.rootDirectory = Optional.of(file.getAbsolutePath());
            return this;
        }

        public Builder useWorkingDirectoryEnvProperty() {
            this.rootDirectory = Optional.ofNullable(System.getProperty(Configuration.WORKING_DIRECTORY));
            if (!this.rootDirectory.isPresent()) {
                throw new MissingArgumentException("Server needs a working.directory env entry");
            }
            return this;
        }

        public Builder configurationPath(String path) {
            this.configurationPath = Optional.of(path);
            return this;
        }

        public Builder configurationFromClasspath() {
            this.configurationPath = Optional.of("classpath:");
            return this;
        }

        public Configuration build() {
            return new Configuration(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")), this.configurationPath.orElse("file://conf/"));
        }
    }
}

