/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class ConvertTo7Bit
extends GenericMailet {
    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        try {
            this.convertTo7Bit((MimePart)message);
            message.saveChanges();
        }
        catch (IOException e) {
            throw new MessagingException("IOException converting message to 7bit: " + e.getMessage(), (Exception)e);
        }
    }

    private void convertTo7Bit(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            MimeMultipart parts = (MimeMultipart)part.getContent();
            int count = parts.getCount();
            for (int i = 0; i < count; ++i) {
                this.convertTo7Bit((MimePart)parts.getBodyPart(i));
            }
        } else if ("8bit".equals(part.getEncoding())) {
            String contentTransferEncoding = part.isMimeType("text/*") ? "quoted-printable" : "base64";
            part.setContent(part.getContent(), part.getContentType());
            part.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
            part.addHeader("X-MIME-Autoconverted", "from 8bit to " + contentTransferEncoding + " by " + this.getMailetContext().getServerInfo());
        }
    }
}

