/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import junit.framework.TestCase;
import org.xbill.DNS.utils.base16;

public class base16Test
extends TestCase {
    public base16Test(String name) {
        super(name);
    }

    public void test_toString_emptyArray() {
        String out = base16.toString(new byte[0]);
        base16Test.assertEquals((String)"", (String)out);
    }

    public void test_toString_singleByte1() {
        byte[] data = new byte[]{1};
        String out = base16.toString(data);
        base16Test.assertEquals((String)"01", (String)out);
    }

    public void test_toString_singleByte2() {
        byte[] data = new byte[]{16};
        String out = base16.toString(data);
        base16Test.assertEquals((String)"10", (String)out);
    }

    public void test_toString_singleByte3() {
        byte[] data = new byte[]{-1};
        String out = base16.toString(data);
        base16Test.assertEquals((String)"FF", (String)out);
    }

    public void test_toString_array1() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        String out = base16.toString(data);
        base16Test.assertEquals((String)"0102030405060708090A0B0C0D0E0F", (String)out);
    }

    public void test_fromString_emptyString() {
        String data = "";
        byte[] out = base16.fromString(data);
        base16Test.assertEquals((int)0, (int)out.length);
    }

    public void test_fromString_invalidStringLength() {
        String data = "1";
        byte[] out = base16.fromString(data);
        base16Test.assertNull((Object)out);
    }

    public void test_fromString_nonHexChars() {
        String data = "GG";
        byte[] out = base16.fromString(data);
    }

    public void test_fromString_normal() {
        String data = "0102030405060708090A0B0C0D0E0F";
        byte[] out = base16.fromString(data);
        byte[] exp = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        base16Test.assertEquals((int)exp.length, (int)out.length);
        for (int i = 0; i < exp.length; ++i) {
            base16Test.assertEquals((byte)exp[i], (byte)out[i]);
        }
    }
}

