/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Options;

public class OptionsTest
extends TestCase {
    public void setUp() {
        Options.clear();
    }

    public void test_set_1arg() {
        Options.set("Option1");
        OptionsTest.assertEquals((String)"true", (String)Options.value("option1"));
        Options.set("OPTION2");
        OptionsTest.assertEquals((String)"true", (String)Options.value("option1"));
        OptionsTest.assertEquals((String)"true", (String)Options.value("OpTIOn2"));
        Options.set("option2");
        OptionsTest.assertEquals((String)"true", (String)Options.value("option2"));
    }

    public void test_set_2arg() {
        Options.set("OPTION1", "Value1");
        OptionsTest.assertEquals((String)"value1", (String)Options.value("Option1"));
        Options.set("option2", "value2");
        OptionsTest.assertEquals((String)"value1", (String)Options.value("Option1"));
        OptionsTest.assertEquals((String)"value2", (String)Options.value("OPTION2"));
        Options.set("OPTION2", "value2b");
        OptionsTest.assertEquals((String)"value1", (String)Options.value("Option1"));
        OptionsTest.assertEquals((String)"value2b", (String)Options.value("option2"));
    }

    public void test_check() {
        OptionsTest.assertFalse((boolean)Options.check("No Options yet"));
        Options.set("First Option");
        OptionsTest.assertFalse((boolean)Options.check("Not a valid option name"));
        OptionsTest.assertTrue((boolean)Options.check("First Option"));
        OptionsTest.assertTrue((boolean)Options.check("FIRST option"));
    }

    public void test_unset() {
        Options.unset("Not an option Name");
        Options.set("Temporary Option");
        OptionsTest.assertTrue((boolean)Options.check("Temporary Option"));
        Options.unset("Temporary Option");
        OptionsTest.assertFalse((boolean)Options.check("Temporary Option"));
        Options.set("Temporary Option");
        OptionsTest.assertTrue((boolean)Options.check("Temporary Option"));
        Options.unset("temporary option");
        OptionsTest.assertFalse((boolean)Options.check("Temporary Option"));
        Options.unset("Still Not an Option Name");
    }

    public void test_value() {
        OptionsTest.assertNull((Object)Options.value("Table is Null"));
        Options.set("Testing Option");
        OptionsTest.assertNull((Object)Options.value("Not an Option Name"));
        OptionsTest.assertEquals((String)"true", (String)Options.value("Testing OPTION"));
    }

    public void test_intValue() {
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("Table is Null"));
        Options.set("A Boolean Option");
        Options.set("An Int Option", "13");
        Options.set("Not An Int Option", "NotAnInt");
        Options.set("A Negative Int Value", "-1000");
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("A Boolean Option"));
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("Not an Option NAME"));
        OptionsTest.assertEquals((int)13, (int)Options.intValue("an int option"));
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("NOT an INT option"));
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("A negative int Value"));
    }

    public void test_systemProperty() {
        System.setProperty("dnsjava.options", "booleanOption,valuedOption1=10,valuedOption2=NotAnInteger");
        Options.refresh();
        OptionsTest.assertTrue((boolean)Options.check("booleanOPTION"));
        OptionsTest.assertTrue((boolean)Options.check("booleanOption"));
        OptionsTest.assertTrue((boolean)Options.check("valuedOption1"));
        OptionsTest.assertTrue((boolean)Options.check("ValuedOption2"));
        OptionsTest.assertEquals((String)"true", (String)Options.value("booleanOption"));
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("BOOLEANOPTION"));
        OptionsTest.assertEquals((String)"10", (String)Options.value("valuedOption1"));
        OptionsTest.assertEquals((int)10, (int)Options.intValue("valuedOption1"));
        OptionsTest.assertEquals((String)"notaninteger", (String)Options.value("VALUEDOPTION2"));
        OptionsTest.assertEquals((int)-1, (int)Options.intValue("valuedOption2"));
    }
}

