/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.jdkim.DKIMVerifier;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.mailets.CRLFOutputStream;
import org.apache.james.jdkim.mailets.HeaderSkippingOutputStream;
import org.apache.james.jdkim.mailets.MimeMessageHeaders;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DKIMVerify
extends GenericMailet {
    public static final String DKIM_AUTH_RESULT_ATTRIBUTE = "jDKIM.AUTHRESULT";
    protected DKIMVerifier verifier = null;
    private boolean forceCRLF;

    public void init() throws MessagingException {
        this.verifier = new DKIMVerifier();
        this.forceCRLF = this.getInitParameter("forceCRLF", true);
    }

    public void service(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            List<SignatureRecord> res = DKIMVerify.verify(this.verifier, message, this.forceCRLF);
            if (res == null || res.isEmpty()) {
                mail.setAttribute(DKIM_AUTH_RESULT_ATTRIBUTE, (Serializable)((Object)"neutral (no signatures)"));
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("pass");
                for (SignatureRecord rec : res) {
                    msg.append(" (");
                    msg.append("identity ");
                    msg.append(((Object)rec.getIdentity()).toString());
                    msg.append(")");
                }
                mail.setAttribute(DKIM_AUTH_RESULT_ATTRIBUTE, (Serializable)((Object)msg.toString()));
            }
        }
        catch (FailException e) {
            mail.setAttribute(DKIM_AUTH_RESULT_ATTRIBUTE, (Serializable)((Object)("fail (" + (e.getRelatedRecordIdentity() != null ? "identity " + e.getRelatedRecordIdentity() + ": " : "") + e.getMessage() + ")")));
        }
    }

    protected static List<SignatureRecord> verify(DKIMVerifier verifier, MimeMessage message, boolean forceCRLF) throws MessagingException, FailException {
        MimeMessageHeaders headers = new MimeMessageHeaders(message);
        BodyHasher bh = verifier.newBodyHasher((Headers)headers);
        try {
            if (bh != null) {
                FilterOutputStream os = new HeaderSkippingOutputStream(bh.getOutputStream());
                if (forceCRLF) {
                    os = new CRLFOutputStream(os);
                }
                message.writeTo((OutputStream)os);
                bh.getOutputStream().close();
            }
        }
        catch (IOException e) {
            throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
        }
        return verifier.verify(bh);
    }
}

