/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.imap.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import org.apache.geronimo.javamail.store.imap.connection.IMAPEnvelope;
import org.apache.geronimo.javamail.store.imap.connection.IMAPFetchDataItem;
import org.apache.geronimo.javamail.store.imap.connection.IMAPResponseTokenizer;

public class IMAPBodyStructure
extends IMAPFetchDataItem {
    public ContentType mimeType = new ContentType();
    public ContentDisposition disposition = null;
    public String contentID;
    public String contentDescription;
    public String transferEncoding;
    public int bodySize;
    public int lines = -1;
    public IMAPBodyStructure[] parts;
    public Map dispositionParameters;
    public List languages;
    public String md5Hash;
    public IMAPEnvelope nestedEnvelope;
    public IMAPBodyStructure nestedBody;

    public IMAPBodyStructure(IMAPResponseTokenizer source) throws MessagingException {
        super(3);
        this.parseBodyStructure(source);
    }

    protected void parseBodyStructure(IMAPResponseTokenizer source) throws MessagingException {
        source.checkLeftParen();
        if (source.peek().getType() == 40) {
            this.parseMultipartBodyStructure(source);
        } else {
            this.parseSinglepartBodyStructure(source);
        }
    }

    protected void parseMultipartBodyStructure(IMAPResponseTokenizer source) throws MessagingException {
        this.mimeType.setPrimaryType("multipart");
        ArrayList<IMAPBodyStructure> partList = new ArrayList<IMAPBodyStructure>();
        do {
            IMAPBodyStructure part = new IMAPBodyStructure(source);
            partList.add(part);
        } while (source.peek().getType() == 40);
        this.parts = partList.toArray(new IMAPBodyStructure[partList.size()]);
        this.mimeType.setSubType(source.readString());
        if (source.checkListEnd()) {
            return;
        }
        if (source.checkListEnd()) {
            return;
        }
        this.mimeType.setParameterList(source.readParameterList());
        if (source.checkListEnd()) {
            return;
        }
        this.parseMessageExtensions(source);
    }

    protected void parseSinglepartBodyStructure(IMAPResponseTokenizer source) throws MessagingException {
        this.mimeType.setPrimaryType(source.readString());
        this.mimeType.setSubType(source.readString());
        this.mimeType.setParameterList(source.readParameterList());
        this.contentID = source.readStringOrNil();
        this.contentDescription = source.readStringOrNil();
        this.transferEncoding = source.readStringOrNil();
        this.bodySize = source.readInteger();
        if (this.mimeType.match("message/rfc822")) {
            this.nestedEnvelope = new IMAPEnvelope(source);
            this.nestedBody = new IMAPBodyStructure(source);
            this.lines = source.readInteger();
        } else if (this.mimeType.match("text/*")) {
            this.lines = source.readInteger();
        }
        if (source.checkListEnd()) {
            return;
        }
        this.md5Hash = source.readString();
        this.parseMessageExtensions(source);
    }

    protected void parseMessageExtensions(IMAPResponseTokenizer source) throws MessagingException {
        if (source.checkListEnd()) {
            return;
        }
        this.disposition = new ContentDisposition();
        this.disposition.setDisposition(source.readString());
        this.disposition.setParameterList(source.readParameterList());
        if (source.checkListEnd()) {
            return;
        }
        this.languages = source.readStringList();
        if (source.checkListEnd()) {
            return;
        }
        source.readStringList();
        while (source.notListEnd()) {
            source.skipExtensionItem();
        }
    }

    public boolean isMultipart() {
        return this.parts != null;
    }

    public boolean isAttachedMessage() {
        return !this.isMultipart() && this.mimeType.match("message/rfc822");
    }
}

