/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.tagvalue;

import java.util.Set;
import junit.framework.TestCase;
import org.apache.james.jdkim.tagvalue.TagValue;

public class TagValueTest
extends TestCase {
    public void testEmpty() {
        new TagValue("");
    }

    public void testValid() {
        new TagValue("v=DKIM1; p=ciao; s=cips;");
        new TagValue("v=");
        new TagValue("v=;");
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("v=", "v=;"));
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("v=", "v= ;"));
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("v=", "v=\r\n ;"));
        TagValueTest.assertFalse((boolean)this.tagValuesEquals("", "v=;"));
    }

    public void testInvalidSyntax() {
        try {
            new TagValue("_p=ciao; s=cips; v=DKIM1;");
            TagValueTest.fail((String)"expected invalid tag exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDoubleTag() {
        try {
            new TagValue("s=ciao; s=cips; v=DKIM1;");
            TagValueTest.fail((String)"expected duplicate tag exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidFWS() {
        try {
            new TagValue("\r\n");
            TagValueTest.fail((String)"we only expect WSP/FWS withing a tag-value. No FWS/WSP allowed with no tag");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidFWSSyntax() {
        try {
            new TagValue("p=test \r\n\r\n ");
            TagValueTest.fail((String)"expecting WSP after CRLF to handle it as FWS");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            new TagValue("p=\r\n\r\n test");
            TagValueTest.fail((String)"expecting WSP after CRLF to handle it as FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidFWSStartSyntax() {
        try {
            new TagValue("\r\np=ciao; s=cips; v=DKIM1;");
            TagValueTest.fail((String)"\\r\\n at the beginning is not valid FWS");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            new TagValue("\t\r\np=ciao; s=cips; v=DKIM1;");
            TagValueTest.fail((String)"\\t\\r\\n at the beginning is not valid FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInvalidFWSEndSyntax() {
        try {
            new TagValue("p\r\n=ciao; s=cips; v=DKIM1;");
            TagValueTest.fail((String)"\\r\\n at the end is not valid FWS");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            new TagValue("p \r\n=ciao; s=cips; v=DKIM1;");
            TagValueTest.fail((String)"\\r\\n at the end is not valid FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValidFWSTags() {
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("\r\n\tp=ciao; s=cips; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("p\r\n =ciao; s=cips; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("p\r\n = \r\n\tciao; s=cips; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        TagValueTest.assertTrue((boolean)this.tagValuesEquals("p\r\n = ciao; s=cips\r\n\t; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
    }

    public void testNoTermination() {
        TagValue t = new TagValue("\r\n\tp=ciao; s=cips; v=DKIM1\r\n\t");
        TagValueTest.assertEquals((Object)"DKIM1", (Object)t.getValue("v"));
    }

    public void testSingleValue() {
        TagValue t = new TagValue("\r\n\tp  =      hi\t");
        TagValueTest.assertEquals((Object)"hi", (Object)t.getValue("p"));
    }

    public void testWSPinValue() {
        TagValue t = new TagValue("\r\n\tp  = \r\n hi \thi hi \t hi\t");
        TagValueTest.assertEquals((Object)"hi \thi hi \t hi", (Object)t.getValue("p"));
    }

    public void testFWSinValue() {
        TagValue t = new TagValue("\r\n\tp  = \r\n hi \thi\r\n hi \t hi\t");
        TagValueTest.assertEquals((Object)"hi \thi\r\n hi \t hi", (Object)t.getValue("p"));
    }

    public void testNoEqual() {
        try {
            new TagValue("\r\n\tp        hi\t");
            TagValueTest.fail((String)"Expected value");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            new TagValue("v=DKIM1; pciao; s=cips;");
            TagValueTest.fail((String)"Expected value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEndingWSP() {
        new TagValue("t=value; ");
    }

    public void testTagSetWithEquals() {
        TagValue tv = new TagValue("t=value; v=encoded=40value");
        Set tags = tv.getTags();
        TagValueTest.assertEquals((int)2, (int)tags.size());
        TagValueTest.assertTrue((boolean)tags.contains("t"));
        TagValueTest.assertTrue((boolean)tags.contains("v"));
    }

    public boolean tagValuesEquals(String t1, String t2) {
        TagValue tv1 = new TagValue(t1);
        TagValue tv2 = new TagValue(t2);
        boolean eq = tv1.equals((Object)tv2);
        if (eq) {
            TagValueTest.assertTrue((tv1.hashCode() == tv2.hashCode() ? 1 : 0) != 0);
        }
        return eq;
    }
}

