/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.james.jdkim.canon.AbstractOutputStreamTestCase;
import org.apache.james.jdkim.canon.LimitedOutputStream;

public class LimitedOutputStreamTest
extends AbstractOutputStreamTestCase {
    private byte[] testData;
    private byte[] expectedData;

    protected void setUp() throws Exception {
        this.testData = "this  is a \r\n  canonicalization \ttest\r\n\r\n\r\n".getBytes();
        this.expectedData = "this  is a \r\n  canonicalizatio".getBytes();
    }

    public void testSingleBytes() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LimitedOutputStream os = new LimitedOutputStream((OutputStream)bos, 30);
        for (int i = 0; i < this.testData.length; ++i) {
            LimitedOutputStreamTest.assertEquals((i >= 30 ? 1 : 0) != 0, (boolean)os.isLimited());
            if (i == 30) {
                this.assertArrayEquals(this.expectedData, bos.toByteArray());
            }
            os.write((int)this.testData[i]);
        }
        os.close();
        LimitedOutputStreamTest.assertEquals((int)30, (int)os.getComputedBytes());
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    public void testChunks() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LimitedOutputStream os = new LimitedOutputStream((OutputStream)bos, 30);
        this.chunker(this.testData, (OutputStream)os);
        LimitedOutputStreamTest.assertEquals((int)30, (int)os.getComputedBytes());
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    protected OutputStream newInstance(ByteArrayOutputStream bos) {
        return new LimitedOutputStream((OutputStream)bos, 30);
    }

    public void testExtensiveChunks() throws NoSuchAlgorithmException, IOException {
        this.extensiveChunker(this.testData, this.expectedData);
    }
}

