/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import junit.framework.TestCase;
import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;

public class SignatureRecordImplTest
extends TestCase {
    public void testQPDecode() {
        SignatureRecordImplTest.assertEquals((String)"", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)""));
        SignatureRecordImplTest.assertEquals((String)"@", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=40"));
        SignatureRecordImplTest.assertEquals((String)"\r\n", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=0D=0A"));
        SignatureRecordImplTest.assertEquals((String)"\u0000CIAO\u0000", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=00CIAO=00"));
        SignatureRecordImplTest.assertEquals((String)"thisisatest", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this\r\n\tis\r\n a\r\n  \t test"));
    }

    public void testQPWhiteSpaces() {
        SignatureRecordImplTest.assertEquals((String)"thisisatest", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this is a test"));
        SignatureRecordImplTest.assertEquals((String)"thisisatest", (String)SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this\r\n is a test"));
    }

    public void testQPInvalid() {
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"==");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=2 3");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=3");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=3a");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"==20");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=20=");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"=3x");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignatureRecordImpl.dkimQuotedPrintableDecode((CharSequence)"this\r\nis a test");
            SignatureRecordImplTest.fail((String)"invalid sequence parsed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testWrongHashSyntaxes() {
        SignatureRecordImpl sr = new SignatureRecordImpl("v=1; a=nothyphenedword;");
        try {
            sr.getHashAlgo();
            SignatureRecordImplTest.fail((String)"expected failure");
        }
        catch (Exception e) {
            SignatureRecordImplTest.assertTrue((e.getMessage().toLowerCase().indexOf("hash") != -1 ? 1 : 0) != 0);
        }
        try {
            sr.getHashMethod();
            SignatureRecordImplTest.fail((String)"expected failure");
        }
        catch (Exception e) {
            SignatureRecordImplTest.assertTrue((e.getMessage().toLowerCase().indexOf("hash") != -1 ? 1 : 0) != 0);
        }
        try {
            sr.getHashAlgo();
            SignatureRecordImplTest.fail((String)"expected failure");
        }
        catch (Exception e) {
            SignatureRecordImplTest.assertTrue((e.getMessage().toLowerCase().indexOf("hash") != -1 ? 1 : 0) != 0);
        }
    }

    public void testExpired() {
        SignatureRecordImpl sr = new SignatureRecordImpl("v=1; c=simple; h=from:to; s=select; d=example.com; a=rsa-sha1; x=0; bh=abcdef; b=1235345987;");
        try {
            sr.validate();
            SignatureRecordImplTest.fail((String)"expected failure");
        }
        catch (Exception e) {
            SignatureRecordImplTest.assertTrue((e.getMessage().indexOf("expired") != -1 ? 1 : 0) != 0);
        }
    }
}

