/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.james.jdkim.DKIMVerifier;
import org.apache.james.jdkim.MockPublicKeyRecordRetriever;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.FailException;

public class PerlDKIMTest
extends TestCase {
    private File file;
    private MockPublicKeyRecordRetriever pkr;

    public PerlDKIMTest(String testName) throws IOException, URISyntaxException {
        this(testName, PerlDKIMTestSuite.getFile(testName), PerlDKIMTest.getPublicRecordRetriever());
    }

    public PerlDKIMTest(String name, File testFile, MockPublicKeyRecordRetriever pkr) {
        super(name);
        this.file = testFile;
        this.pkr = pkr;
    }

    public static MockPublicKeyRecordRetriever getPublicRecordRetriever() throws IOException {
        String line;
        MockPublicKeyRecordRetriever pkr = new MockPublicKeyRecordRetriever();
        BufferedReader fakeDNSlist = new BufferedReader(new InputStreamReader(PerlDKIMTest.class.getResourceAsStream("/org/apache/james/jdkim/Mail-DKIM/FAKE_DNS.dat")));
        while ((line = fakeDNSlist.readLine()) != null) {
            if (line.startsWith("#")) continue;
            int pDK = line.indexOf("._domainkey.");
            int pSp = line.indexOf(" ");
            if (line.charAt(pSp + 1) == ' ') {
                pkr.addRecord(line.substring(0, pDK), line.substring(pDK + "._domainkey.".length(), pSp), line.substring(pSp + 2));
                continue;
            }
            if (!line.substring(pSp + 1).startsWith("~~")) continue;
            pkr.addRecord(line.substring(0, pDK), line.substring(pDK + "._domainkey.".length(), pSp), null);
        }
        return pkr;
    }

    protected void runTest() throws Throwable {
        block17: {
            FileInputStream is = new FileInputStream(this.file);
            this.pkr = PerlDKIMTest.getPublicRecordRetriever();
            boolean expectFailure = false;
            boolean expectNull = false;
            if (this.getName().indexOf("dk_") != -1) {
                expectNull = true;
            } else if (this.getName().indexOf("_ietf") != -1) {
                expectFailure = true;
            } else if (this.getName().startsWith("multiple_1")) {
                expectFailure = true;
            } else if (this.getName().startsWith("no_body")) {
                expectFailure = true;
            } else if (this.getName().startsWith("badkey_")) {
                expectFailure = true;
            } else if (this.getName().startsWith("ignore_")) {
                expectFailure = true;
            } else if (this.getName().startsWith("bad_")) {
                expectFailure = true;
            }
            try {
                List res = new DKIMVerifier((PublicKeyRecordRetriever)this.pkr).verify((InputStream)is);
                if (expectNull) {
                    PerlDKIMTest.assertNull((Object)res);
                }
                if (expectFailure) {
                    PerlDKIMTest.fail((String)"Failure expected!");
                }
            }
            catch (FailException e) {
                if (expectFailure) break block17;
                PerlDKIMTest.fail((String)e.getMessage());
            }
        }
    }

    public static Test suite() throws IOException, URISyntaxException {
        return new PerlDKIMTestSuite();
    }

    static class PerlDKIMTestSuite
    extends TestSuite {
        private static final String TESTS_FOLDER = "/org/apache/james/jdkim/Mail-DKIM/corpus";

        public PerlDKIMTestSuite() throws IOException, URISyntaxException {
            File dir;
            File[] files;
            URL resource = PerlDKIMTestSuite.class.getResource(TESTS_FOLDER);
            if (resource != null && (files = (dir = new File(resource.toURI())).listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    if (!f.getName().toLowerCase().endsWith(".txt")) continue;
                    this.addTest((Test)new PerlDKIMTest(f.getName().substring(0, f.getName().length() - 4), f, PerlDKIMTest.getPublicRecordRetriever()));
                }
            }
        }

        public static File getFile(String name) throws URISyntaxException {
            URL resource = PerlDKIMTestSuite.class.getResource(TESTS_FOLDER + File.separator + name + ".txt");
            if (resource != null) {
                return new File(resource.toURI());
            }
            return null;
        }
    }
}

