/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.apache.isis.core.metamodel.facets.object.bookmarkpolicy;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Bookmarkable;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.FacetFactory.ProcessClassContext;
import org.apache.isis.core.metamodel.facets.AbstractFacetFactoryTest;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.bookmarkable.BookmarkPolicyFacetViaBookmarkableAnnotation;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.bookmarkable.BookmarkPolicyFacetViaBookmarkableAnnotationElseFallbackFactory;

public class BookmarkableAnnotationFacetFactoryTest_class extends AbstractFacetFactoryTest {

    private BookmarkPolicyFacetViaBookmarkableAnnotationElseFallbackFactory facetFactory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();

        facetFactory = new BookmarkPolicyFacetViaBookmarkableAnnotationElseFallbackFactory();
    }

    @Override
    protected void tearDown() throws Exception {
        facetFactory = null;
        super.tearDown();
    }

    public void testBookmarkableAnnotationPickedUpOnClass() {
        @Bookmarkable(BookmarkPolicy.AS_CHILD)
        class Customer {
        }

        facetFactory.process(new ProcessClassContext(Customer.class, null, methodRemover, facetedMethod));

        final Facet facet = facetedMethod.getFacet(BookmarkPolicyFacet.class);
        assertNotNull(facet);
        assertTrue(facet instanceof BookmarkPolicyFacetViaBookmarkableAnnotation);
        BookmarkPolicyFacet bookmarkableFacet = (BookmarkPolicyFacet) facet;
        assertThat(bookmarkableFacet.value(), is(BookmarkPolicy.AS_CHILD));
        
        assertNoMethodsRemoved();
    }

    public void testBookmarkablePolicyInferredPickedUpOnClassAndDefaultsToAlways() {
        class Customer {
        }

        facetFactory.process(new ProcessClassContext(Customer.class, null, methodRemover, facetedMethod));

        final Facet facet = facetedMethod.getFacet(BookmarkPolicyFacet.class);
        assertNotNull(facet);
        assertTrue(facet instanceof BookmarkPolicyFacetFallback);
        BookmarkPolicyFacet bookmarkableFacet = (BookmarkPolicyFacet) facet;
        assertThat(bookmarkableFacet.value(), is(BookmarkPolicy.NEVER));
        
        assertNoMethodsRemoved();
    }

}
