/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.isis.core.commons.lang;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;

import org.junit.Test;

public class IterableExtensionsTest_fold {

    @Test
    public void happyCase() throws Exception {

        class SummingClosure implements Closure<Double> {
            private double sum = 0;

            public Double execute(Double amount) {
                sum += amount; // apply '+=' operator
                return sum; // return current accumulated value
            }
        }

        SummingClosure closure = new SummingClosure();

        Double result = IterableExtensions.fold(Arrays.asList(new Double[] { 99., 127., 35. }), closure);
        assertEquals(261.0, result, 0.000000001);
    }

}
