#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package domainapp.modules.simple.specglue;

import java.util.List;
import java.util.UUID;

import javax.inject.Inject;

import org.apache.isis.core.specsupport.specs.CukeGlueAbstract2;

import cucumber.api.java.en.Given;
import cucumber.api.java.en.When;
import domainapp.modules.simple.dom.impl.SimpleObject;
import domainapp.modules.simple.dom.impl.SimpleObjects;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

public class SimpleObjectMenuGlue extends CukeGlueAbstract2 {

    @Given("^there are.* (${symbol_escape}${symbol_escape}d+) simple objects${symbol_dollar}")
    public void there_are_N_simple_objects(int n) throws Throwable {
        final List<SimpleObject> list = wrap(simpleObjects).listAll();
        assertThat(list.size(), is(n));
    }
    
    @When("^.*create a .*simple object${symbol_dollar}")
    public void create_a_simple_object() throws Throwable {
        wrap(simpleObjects).create(UUID.randomUUID().toString());
    }

    @Inject
    SimpleObjects simpleObjects;

}
