/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;

public abstract class WrappedRunnable
implements Runnable {
    @Override
    public final void run() {
        try {
            this.runMayThrow();
        }
        catch (Throwable e) {
            throw ScheduledExecutorUtil.propagate(e);
        }
    }

    public abstract void runMayThrow() throws Throwable;

    public static WrappedRunnable wrap(final Runnable runnable) {
        if (runnable instanceof WrappedRunnable) {
            return (WrappedRunnable)runnable;
        }
        return new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                runnable.run();
            }
        };
    }
}

