/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.query.dataset;

import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NullFieldException;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.read.query.dataset.ResultSet;
import org.apache.tsfile.read.query.dataset.ResultSetMetadata;
import org.apache.tsfile.read.query.dataset.ResultSetMetadataImpl;

public abstract class AbstractResultSet
implements ResultSet {
    protected ResultSetMetadata resultSetMetadata;
    protected Map<String, Integer> columnNameToColumnIndexMap;
    protected RowRecord currentRow;

    protected AbstractResultSet(List<String> columnNameList, List<TSDataType> tsDataTypeList) {
        this.resultSetMetadata = new ResultSetMetadataImpl(columnNameList, tsDataTypeList);
        int columnNum = tsDataTypeList.size() + 1;
        this.columnNameToColumnIndexMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int columnIndex = 1; columnIndex <= columnNum; ++columnIndex) {
            this.columnNameToColumnIndexMap.put(this.resultSetMetadata.getColumnName(columnIndex), columnIndex);
        }
    }

    @Override
    @TsFileApi
    public ResultSetMetadata getMetadata() {
        return this.resultSetMetadata;
    }

    @Override
    @TsFileApi
    public abstract boolean next() throws IOException;

    @Override
    @TsFileApi
    public int getInt(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getInt(columnIndex);
    }

    @Override
    @TsFileApi
    public int getInt(int columnIndex) {
        return this.getNonNullField(columnIndex).getIntV();
    }

    @Override
    @TsFileApi
    public long getLong(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getLong(columnIndex);
    }

    @Override
    @TsFileApi
    public long getLong(int columnIndex) {
        return this.getNonNullField(columnIndex).getLongV();
    }

    @Override
    @TsFileApi
    public float getFloat(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getFloat(columnIndex);
    }

    @Override
    @TsFileApi
    public float getFloat(int columnIndex) {
        return this.getNonNullField(columnIndex).getFloatV();
    }

    @Override
    @TsFileApi
    public double getDouble(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getDouble(columnIndex);
    }

    @Override
    @TsFileApi
    public double getDouble(int columnIndex) {
        return this.getNonNullField(columnIndex).getDoubleV();
    }

    @Override
    @TsFileApi
    public boolean getBoolean(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getBoolean(columnIndex);
    }

    @Override
    @TsFileApi
    public boolean getBoolean(int columnIndex) {
        return this.getNonNullField(columnIndex).getBoolV();
    }

    @Override
    @TsFileApi
    public String getString(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getString(columnIndex);
    }

    @Override
    @TsFileApi
    public String getString(int columnIndex) {
        return this.getNonNullField(columnIndex).getStringValue();
    }

    @Override
    @TsFileApi
    public LocalDate getDate(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getDate(columnIndex);
    }

    @Override
    @TsFileApi
    public LocalDate getDate(int columnIndex) {
        return this.getNonNullField(columnIndex).getDateV();
    }

    @Override
    @TsFileApi
    public byte[] getBinary(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        return this.getBinary(columnIndex);
    }

    @Override
    @TsFileApi
    public byte[] getBinary(int columnIndex) {
        return this.getNonNullField(columnIndex).getBinaryV().getValues();
    }

    @Override
    @TsFileApi
    public boolean isNull(String columnName) {
        Integer columnIndex = this.columnNameToColumnIndexMap.get(columnName);
        if (columnIndex == null) {
            throw new IllegalArgumentException("Can't find columnName " + columnName + " from result set");
        }
        return this.isNull(columnIndex);
    }

    @Override
    @TsFileApi
    public boolean isNull(int columnIndex) {
        return this.getField(columnIndex) == null;
    }

    protected Field getNonNullField(int columnIndex) {
        Field field = this.getField(columnIndex);
        if (field == null) {
            throw new NullFieldException("Field in columnIndex " + columnIndex + " is null");
        }
        return field;
    }

    protected Field getField(int columnIndex) {
        Field field;
        if (columnIndex > this.columnNameToColumnIndexMap.size() || columnIndex <= 0) {
            throw new IndexOutOfBoundsException("column index " + columnIndex + " out of bound");
        }
        if (columnIndex == 1) {
            field = new Field(TSDataType.INT64);
            field.setLongV(this.currentRow.getTimestamp());
        } else {
            field = this.currentRow.getField(columnIndex - 2);
        }
        return field;
    }

    @Override
    @TsFileApi
    public abstract void close();
}

